/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui;

import com.google.common.base.Preconditions;
import fr.ifremer.echobase.config.EchoBaseConfiguration;
import fr.ifremer.echobase.entities.DriverType;
import fr.ifremer.echobase.entities.TopiaEchoBaseInternalPersistenceContext;
import fr.ifremer.echobase.entities.spatial.SpatialDataCache;
import fr.ifremer.echobase.persistence.EchoBaseDbMeta;
import fr.ifremer.echobase.persistence.EchoBaseEntityHelper;
import fr.ifremer.echobase.services.DefaultEchoBaseServiceContext;
import fr.ifremer.echobase.services.EchoBaseServiceContext;
import fr.ifremer.echobase.services.service.UserService;
import fr.ifremer.echobase.services.service.embeddedapplication.EmbeddedApplicationService;
import fr.ifremer.echobase.services.service.workingDb.WorkingDbConfigurationService;
import fr.ifremer.echobase.ui.EchoBaseApplicationContext;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class EchoBaseApplicationListener
implements ServletContextListener {
    protected static final Log log;

    public void contextInitialized(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application starting at " + new Date() + "..."));
        }
        EchoBaseApplicationContext applicationContext = new EchoBaseApplicationContext();
        EchoBaseApplicationContext.setApplicationContext((ServletContext)sce.getServletContext(), (EchoBaseApplicationContext)applicationContext);
        applicationContext.init();
        EchoBaseServiceContext serviceContext = DefaultEchoBaseServiceContext.newContext((Locale)Locale.getDefault(), (EchoBaseConfiguration)applicationContext.getConfiguration(), (EchoBaseDbMeta)applicationContext.getDbMeta(), (SpatialDataCache)applicationContext.getSpatialDataCache());
        this.initInternalDatabase(applicationContext, serviceContext);
        try {
            this.copyDriverFiles(serviceContext);
        }
        catch (IOException e) {
            throw new TopiaException("Could not install drivers", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application is ending at " + new Date() + "..."));
        }
        ServletContext servletContext = sce.getServletContext();
        EchoBaseApplicationContext applicationContext = EchoBaseApplicationContext.getApplicationContext((ServletContext)servletContext);
        EchoBaseApplicationContext.removeApplicationContext((ServletContext)servletContext);
        applicationContext.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInternalDatabase(EchoBaseApplicationContext context, EchoBaseServiceContext serviceContext) throws TopiaException {
        Preconditions.checkNotNull((Object)context);
        EchoBaseConfiguration configuration = context.getConfiguration();
        Preconditions.checkNotNull((Object)configuration);
        EchoBaseDbMeta dbMeta = context.getDbMeta();
        Preconditions.checkNotNull((Object)dbMeta);
        TopiaContext rootContext = context.getInternalRootContext();
        Preconditions.checkNotNull((Object)rootContext);
        if (configuration.isUpdateSchema()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Will update schema...");
            }
            rootContext.updateSchema();
        }
        TopiaContext tx = rootContext.beginTransaction();
        try {
            serviceContext.setEchoBaseInternalPersistenceContext(new TopiaEchoBaseInternalPersistenceContext(tx));
            UserService service = (UserService)serviceContext.newService(UserService.class);
            List users = service.getUsers();
            if (CollectionUtils.isEmpty((Collection)users)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"No user in database, will create default users.");
                }
                service.createDefaultUsers();
            }
            if (configuration.isEmbedded()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Will try t create default working db configuration for embedded db.");
                }
                ((WorkingDbConfigurationService)serviceContext.newService(WorkingDbConfigurationService.class)).createEmbeddedWorkingDbConfiguration();
            }
        }
        finally {
            serviceContext.setEchoBaseInternalPersistenceContext(null);
            EchoBaseEntityHelper.closeConnection((TopiaContext)tx);
        }
    }

    protected void copyDriverFiles(EchoBaseServiceContext serviceContext) throws IOException {
        EmbeddedApplicationService service = (EmbeddedApplicationService)serviceContext.newService(EmbeddedApplicationService.class);
        EchoBaseConfiguration configuration = serviceContext.getConfiguration();
        File libDirectory = configuration.getLibDirectory();
        for (DriverType driverType : DriverType.values()) {
            String pilotFileName = driverType.getPilotFileName(configuration);
            File pilotFile = new File(libDirectory, pilotFileName);
            if (pilotFile.exists()) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)("Copy driver " + pilotFileName + " to directory " + libDirectory));
            }
            service.copyEmbeddedBinaryFile(pilotFileName, libDirectory);
        }
    }

    static {
        block5: {
            block4: {
                log = LogFactory.getLog(EchoBaseApplicationListener.class);
                try {
                    Class.forName("org.postgresql.Driver");
                }
                catch (ClassNotFoundException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Could not find pg driver", (Throwable)e);
                }
            }
            try {
                Class.forName("org.h2.Driver");
            }
            catch (ClassNotFoundException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Could not find h2 driver", (Throwable)e);
            }
        }
    }
}

