package fr.ifremer.echobase.ui.actions.workingDb;

/*
 * #%L
 * EchoBase :: UI
 * $Id: Information.java 606 2012-09-03 19:23:14Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-2.0/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/workingDb/Information.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.EchoBaseConfiguration;
import fr.ifremer.echobase.persistence.JdbcConfiguration;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;

/**
 * Display a page to show connection details.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class Information extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    protected JdbcConfiguration dbConfiguration;

    protected String pilotVersion;

    public JdbcConfiguration getDbConfiguration() {
        return dbConfiguration;
    }

    public String getPilotVersion() {
        return pilotVersion;
    }

    @Override
    public String execute() throws Exception {

        EchoBaseConfiguration configuration =
                getEchoBaseApplicationContext().getConfiguration();

        dbConfiguration = getEchoBaseSession().getWorkingDbConfiguration();

        pilotVersion =
                dbConfiguration.getDriverType().getPilotVersion(configuration);

        return SUCCESS;
    }
}
