package fr.ifremer.echobase.ui.actions.workingDb;

/*
 * #%L
 * EchoBase :: UI
 * $Id: Connect.java 619 2012-09-05 11:17:51Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.3/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/workingDb/Connect.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.DriverType;
import fr.ifremer.echobase.persistence.EchoBaseEntityHelper;
import fr.ifremer.echobase.persistence.JdbcConfiguration;
import org.apache.commons.lang3.StringUtils;

import java.sql.SQLException;

/**
 * Connects to an existing working db.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.1
 */
public class Connect extends AbstractWorkingDbAction {

    private static final long serialVersionUID = 1L;

    protected String password;

    protected JdbcConfiguration jdbcConf;

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @InputConfig(methodName = INPUT)
    @Override
    public String execute() throws Exception {

        String result = INPUT;

        try {
            EchoBaseEntityHelper.checkJDBCConnection(jdbcConf);
            getEchoBaseSession().initWorkingDb(jdbcConf);
            addFlashMessage(_("echobase.info.workingDbconfiguration.connected",
                              conf.getUrl()));
            result = SUCCESS;

        } catch (SQLException e) {
            jdbcConf = null;
            addFieldError(
                    "password",
                    _("echobase.error.workingDbConfiguration.couldNotConnect",
                      e.getMessage()));
        }

        return result;
    }

    @Override
    public void validate() {

        jdbcConf = JdbcConfiguration.newConfig(
                getConf().getDriverType(), getConf().getUrl(),
                getConf().getLogin(), password);

        // check connexion is ok
        try {
            EchoBaseEntityHelper.checkJDBCConnection(jdbcConf);
        } catch (SQLException e) {
            jdbcConf = null;
            addFieldError(
                    "password",
                    _("echobase.error.workingDbConfiguration.couldNotConnect",
                      e.getMessage()));
        }
    }

    @Override
    public void prepare() throws Exception {

        super.prepare();

        if (DriverType.H2.equals(conf.getDriverType()) &&
            StringUtils.isBlank(getPassword())) {

            // use a default h2 password
            setPassword("sa");
        }

    }
}
