<%--
  #%L
  EchoBase :: UI
  
  $Id: configure.jsp 644 2012-09-11 12:48:41Z tchemit $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.2/echobase-ui/src/main/webapp/WEB-INF/jsp/importDb/configure.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>

<title><s:text name="echobase.title.importDb"/></title>

<script type="text/javascript">

  jQuery(document).ready(function () {

    // to change form when mode is changed
    $('[name="model.importDbMode"]').change(function (event) {
      $('[class~="importDbMode"]').hide();
      $('#' + this.value).show();
      $('#' + this.value + ' .errorMessage').hide();
    });

    // show incoming mode
    var incomingVal = $('[name="model.importDbMode"][checked="checked"]').val();
    $('#' + incomingVal).show();
  });
</script>

<fieldset>
  <legend>
    <s:text name="echobase.legend.importDb.configuration.selectImportDbMode"/>
  </legend>
  <s:radio id='mode' key='model.importDbMode' list="modes" cssClass="cleanBoth"
           label='%{getText("echobase.common.importDbMode")}'
           required="true" template="myradiomap"/>
</fieldset>

<s:form id="REFERENTIAL" namespace="/importDb" method="POST"
        enctype="multipart/form-data" cssClass="hidden importDbMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importDb.configuration"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="%{getDocumentation('importDb.html','import-referential')}"
           target="doc">
        <s:text name="echobase.action.show.importDb.documentation"/>
      </s:a>
    </div>
    <br/>
    <s:hidden key="model.importDbMode" value="REFERENTIAL" label=''/>
    <s:file name="input" required="true" key="echobase.common.importDbFile"/>

  </fieldset>
  <br/>
  <s:submit action="configureReferential"
            value='%{getText("echobase.action.import")}'/>
</s:form>

<s:form id="DATA" namespace="/importDb" method="POST"
        enctype="multipart/form-data" cssClass="hidden importDbMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importDb.configuration"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="%{getDocumentation('importDb.html','data')}"
           target="doc">
        <s:text name="echobase.action.show.importDb.documentation"/>
      </s:a>
    </div>
    <br/>
    <s:hidden key="model.importDbMode" value="DATA" label=''/>
    <s:file name="input" required="true" key="echobase.common.importDbFile"/>

  </fieldset>
  <br/>
  <s:submit action="configureData"
            value='%{getText("echobase.action.import")}'/>
</s:form>

<s:form id="FREE" namespace="/importDb" method="POST"
        enctype="multipart/form-data" cssClass="hidden importDbMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importDb.configuration"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="%{getDocumentation('importDb.html','free')}"
           target="doc">
        <s:text name="echobase.action.show.importDb.documentation"/>
      </s:a>
    </div>
    <br/>
    <s:hidden key="model.importDbMode" value="FREE" label=''/>
    <s:file name="input" required="true" key="echobase.common.importDbFile"/>

  </fieldset>
  <br/>
  <s:submit action="configureFree"
            value='%{getText("echobase.action.import")}'/>
</s:form>