/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.entities.ImportType;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.DbEditorService;
import fr.ifremer.echobase.services.DecoratorService;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.ui.actions.AbstractJSONPaginedAction;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.decorator.Decorator;

public class GetEntities
extends AbstractJSONPaginedAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GetEntities.class);
    protected EchoBaseEntityEnum entityType;
    protected Map<?, ?>[] datas;

    public void setEntityType(EchoBaseEntityEnum entityType) {
        this.entityType = entityType;
    }

    public Map<?, ?>[] getDatas() {
        return this.datas;
    }

    public String execute() throws Exception {
        Boolean ascendantOrder = this.isSortAscendant();
        String sortColumn = this.getSortColumn();
        this.initFilter();
        if (log.isDebugEnabled()) {
            log.debug((Object)("filters      = " + this.getFilters()));
            log.debug((Object)("sidx         = " + sortColumn));
            log.debug((Object)("sord         = " + ascendantOrder));
        }
        this.datas = ((DbEditorService)this.getService(DbEditorService.class)).getData(this.entityType, this.pager);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Total page = " + this.getTotal()));
        }
        return "success";
    }

    public String entityModificationLogs() throws Exception {
        this.entityType = EchoBaseEntityEnum.EntityModificationLog;
        this.execute();
        return "success";
    }

    public String entityImportLogs() throws Exception {
        this.entityType = EchoBaseEntityEnum.ImportLog;
        this.execute();
        Map importTypes = this.decorateEnums((Enum[])ImportType.values());
        Decorator voyageDecorator = ((DecoratorService)this.getService(DecoratorService.class)).getDecorator(this.getLocale(), Voyage.class, null);
        EchoBaseServiceSupport service = (EchoBaseServiceSupport)this.getService(EchoBaseServiceSupport.class);
        for (Map row : this.datas) {
            String importType = (String)row.get("importType");
            String importTypeToString = (String)importTypes.get(importType);
            row.put("importType", importTypeToString);
            String voyageId = (String)row.get("voyageId");
            Voyage voyage = (Voyage)service.getEntityById(Voyage.class, voyageId);
            String voyageToString = voyageDecorator.toString((Object)voyage);
            row.put("voyage", voyageToString);
        }
        return "success";
    }
}

