/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportDb;

import fr.ifremer.echobase.services.exportdb.ExportDbConfiguration;
import fr.ifremer.echobase.ui.actions.AbstractConfigureAction;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public class Configure
extends AbstractConfigureAction<ExportDbConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Configure.class);

    public Configure() {
        super(ExportDbConfiguration.class);
    }

    protected ExportDbConfiguration createModel() {
        ExportDbConfiguration result = new ExportDbConfiguration();
        result.setFileName("echobase");
        return result;
    }

    public void setFileName(String fileName) {
        ((ExportDbConfiguration)this.getModel()).setFileName(fileName);
    }

    protected void prepareExecuteAction(ExportDbConfiguration model) throws IOException {
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-exportDb-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary((File)dataDirectory);
        model.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Temporary directory to use : " + dataDirectory));
        }
    }
}

