/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: Configure.java 589 2012-09-02 15:11:02Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/exportDb/Configure.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.exportDb;

import fr.ifremer.echobase.services.exportdb.ExportDbConfiguration;
import fr.ifremer.echobase.ui.actions.AbstractConfigureAction;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

import java.io.File;
import java.io.IOException;

/**
 * Configure the complete db export.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class Configure extends AbstractConfigureAction<ExportDbConfiguration> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(Configure.class);

    public Configure() {
        super(ExportDbConfiguration.class);
    }

    @Override
    protected ExportDbConfiguration createModel() {
        ExportDbConfiguration result = new ExportDbConfiguration();
        result.setFileName("echobase");
        return result;
    }

    public void setFileName(String fileName) {
        getModel().setFileName(fileName);
    }

    @Override
    protected void prepareExecuteAction(ExportDbConfiguration model) throws IOException {

        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory,
                                      "echobase-exportDb-" +
                                      System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary(dataDirectory);
        model.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info("Temporary directory to use : " + dataDirectory);
        }
    }
}