/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: GetEntities.java 589 2012-09-02 15:11:02Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/dbeditor/GetEntities.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.services.DbEditorService;
import fr.ifremer.echobase.ui.actions.AbstractJSONPaginedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Map;

/**
 * To obtain the data for the given request.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class GetEntities extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(GetEntities.class);

    /** Type of entity to load. */
    protected EchoBaseEntityEnum entityType;

    /** Datas of the given table. */
    protected Map<?, ?>[] datas;

    public void setEntityType(EchoBaseEntityEnum entityType) {
        this.entityType = entityType;
    }

    public Map<?, ?>[] getDatas() {
        return datas;
    }

    @Override
    public Integer getRows() {
        return pager.getPageSize();
    }

    @Override
    public Integer getPage() {
        return pager.getPageIndex();
    }

    @Override
    public Integer getTotal() {
        return pager.getPagesNumber();
    }

    @Override
    public Integer getRecords() {
        return pager.getRecords();
    }

    @Override
    public String execute() throws Exception {

        Boolean ascendantOrder = isSortAscendant();
        String sortColumn = getSortColumn();

        initFilter();

        if (log.isDebugEnabled()) {
            log.debug("filters      = " + getFilters());
            log.debug("sidx         = " + sortColumn);
            log.debug("sord         = " + ascendantOrder);
        }

        datas = getService(DbEditorService.class).getDatas(
                entityType,
                pager,
                sortColumn,
                ascendantOrder
        );

        if (log.isDebugEnabled()) {
            log.debug("Total page = " + getTotal());
        }

        return SUCCESS;
    }


    public String entityModificationLogs() throws Exception {
        entityType = EchoBaseEntityEnum.EntityModificationLog;
        execute();
        return SUCCESS;
    }
}
