/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.configurations.AcousticDataImportConfiguration;
import fr.ifremer.echobase.services.configurations.CellPositionReference;
import fr.ifremer.echobase.ui.actions.importData.AbstractConfigureImport;
import java.io.File;
import java.util.Map;

public class ConfigureAccousticData
extends AbstractConfigureImport<AcousticDataImportConfiguration> {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> voyages;
    protected Map<String, String> cellPositionReferences;

    public ConfigureAccousticData() {
        super(AcousticDataImportConfiguration.class);
    }

    protected AcousticDataImportConfiguration createModel() {
        return new AcousticDataImportConfiguration(this.getLocale());
    }

    public String input() throws Exception {
        super.input();
        EchoBaseServiceSupport service = (EchoBaseServiceSupport)this.newService(EchoBaseServiceSupport.class);
        this.voyages = this.loadSortAndDecorate(service, Voyage.class);
        this.cellPositionReferences = this.decorateEnums((Enum[])CellPositionReference.values());
        if (((AcousticDataImportConfiguration)this.getModel()).getCellPositionReference() == null) {
            ((AcousticDataImportConfiguration)this.getModel()).setCellPositionReference(CellPositionReference.START);
        }
        return "input";
    }

    public Map<String, String> getVoyages() {
        return this.voyages;
    }

    public Map<String, String> getCellPositionReferences() {
        return this.cellPositionReferences;
    }

    public void setMoviesFile(File file) {
        ((AcousticDataImportConfiguration)this.getModel()).getMoviesFile().setFile(file);
    }

    public void setMoviesFileContentType(String contentType) {
        ((AcousticDataImportConfiguration)this.getModel()).getMoviesFile().setContentType(contentType);
    }

    public void setMoviesFileFileName(String fileName) {
        ((AcousticDataImportConfiguration)this.getModel()).getMoviesFile().setFileName(fileName);
    }
}

