/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui;

import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.services.configurations.AbstractImportConfiguration;
import fr.ifremer.echobase.services.configurations.EmbeddedApplicationConfiguration;
import fr.ifremer.echobase.services.configurations.ExportDbConfiguration;
import fr.ifremer.echobase.services.configurations.ImportDbConfiguration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EchoBaseSession {
    private static final Log log = LogFactory.getLog(EchoBaseSession.class);
    protected static final String PROPERTY_ECHO_BASE_USER = "echobaseUser";
    protected static final String PROPERTY_IMPORT_DB_CONFIGURATION = "importDbConfiguration";
    protected static final String PROPERTY_EXPORT_DB_CONFIGURATION = "exportDbConfiguration";
    protected static final String PROPERTY_EMBEDDED_APPLICATION_CONFIGURATION = "embeddedApplicationConfiguration";
    protected Map<String, Object> store = new TreeMap();

    public EchoBaseUser getEchoBaseUser() {
        return (EchoBaseUser)this.get(PROPERTY_ECHO_BASE_USER, EchoBaseUser.class);
    }

    public void setEchoBaseUser(EchoBaseUser echoBaseUser) {
        this.set(PROPERTY_ECHO_BASE_USER, (Object)echoBaseUser);
    }

    public ImportDbConfiguration getImportDbConfiguration() {
        return (ImportDbConfiguration)this.get(PROPERTY_IMPORT_DB_CONFIGURATION, ImportDbConfiguration.class);
    }

    public void setImportDbConfiguration(ImportDbConfiguration configuration) {
        this.set(PROPERTY_IMPORT_DB_CONFIGURATION, (Object)configuration);
    }

    public ExportDbConfiguration getExportDbConfiguration() {
        return (ExportDbConfiguration)this.get(PROPERTY_EXPORT_DB_CONFIGURATION, ExportDbConfiguration.class);
    }

    public void setExportDbConfiguration(ExportDbConfiguration configuration) {
        this.set(PROPERTY_EXPORT_DB_CONFIGURATION, (Object)configuration);
    }

    public EmbeddedApplicationConfiguration getEmbeddedApplicationConfiguration() {
        return (EmbeddedApplicationConfiguration)this.get(PROPERTY_EMBEDDED_APPLICATION_CONFIGURATION, EmbeddedApplicationConfiguration.class);
    }

    public void setEmbeddedApplicationConfiguration(EmbeddedApplicationConfiguration configuration) {
        this.set(PROPERTY_EMBEDDED_APPLICATION_CONFIGURATION, (Object)configuration);
    }

    public <M extends AbstractImportConfiguration> M getImportDataConfiguration(Class<M> configurationType) {
        return (M)((AbstractImportConfiguration)this.get(configurationType.getSimpleName(), configurationType));
    }

    public <M extends AbstractImportConfiguration> void setImportDataConfiguration(M configuration) {
        this.set(configuration.getClass().getSimpleName(), configuration);
    }

    public <M extends AbstractImportConfiguration> void removeImportDataConfiguration(Class<M> configurationType) {
        this.set(configurationType.getSimpleName(), null);
    }

    public Object remove(String key) {
        Object remove = this.store.remove(key);
        if (log.isInfoEnabled()) {
            log.info((Object)("Remove from user session data [" + key + "] = " + remove));
        }
        return remove;
    }

    public boolean contains(String key) {
        boolean result = this.store.containsKey(key);
        return result;
    }

    protected <T> T get(String key, Class<T> type) {
        Object o = this.store.get(key);
        if (o != null && !type.isInstance(o)) {
            throw new ClassCastException("parameter " + key + " should be of type " + type.getName() + " but was " + o.getClass().getName());
        }
        return (T)o;
    }

    protected void set(String key, Object value) {
        if (value == null) {
            this.remove(key);
        } else {
            this.store.put(key, value);
            if (log.isInfoEnabled()) {
                log.info((Object)("Set in user session data [" + key + "] = " + value));
            }
        }
    }

    public boolean isAdmin() {
        EchoBaseUser user = this.getEchoBaseUser();
        return user != null && user.isAdmin();
    }
}

