<%--
  #%L
  EchoBase :: UI
  
  $Id: configureFiles.jsp 244 2012-01-06 16:19:28Z tchemit $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.2/echobase-ui/src/main/webapp/WEB-INF/jsp/importData/configureFiles.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>

<title><s:text name="echobase.title.importData"/></title>

<script type="text/javascript">

  function updateMode(newValue) {
    switch (newValue) {
      case "ALL":
        $('[class="inputFile"]').show();
        break;
      case "ACOUSTIC":
        $('[class="inputFile"]').hide();
        $('#acousticFile').show();
        break;
    }
  }

  jQuery(document).ready(function () {


    $('[name="importDataMode"]').change(function(event) {
      updateMode(this.value);
    });
    var val = $('[name="importDataMode"][checked="checked"]').val();
    updateMode(val);
  });
</script>

<s:form namespace="/importData" method="POST" enctype="multipart/form-data">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configuration.mission.resume"/>
    </legend>
    <s:label value="%{model.mission.name}"
             key='echobase.common.name'/>

    <s:label value="%{model.mission.missionAbstract}"
             key='echobase.common.missionAbstract'/>
  </fieldset>

  <hr/>
  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configuration.files"/>
    </legend>

    <s:hidden key="missionId" label=''/>

    <s:radio key='importDataMode' list="importDataModes"
             label='%{getText("echobase.common.importDataMode")}'
             required="true"/>
    <hr/>
    <div class="inputFile" id="acousticFile">
      <s:file id="acoustic" name="acoustic" required="true"
              key="echobase.label.import.accoustique"/>
    </div>
    <div class="inputFile" id="captureFile">
      <s:file name="capture" required="true"
              key="echobase.label.import.pecherie"/>
    </div>
    <div class="inputFile" id="lectureAgeGenFile">
      <s:file name="lectureAgeGen" required="true"
              key="echobase.label.import.lectureAgeGen"/>
    </div>
    <div class="inputFile" id="eventsFile">
      <s:file name="events" required="true"
              key="echobase.label.import.events"/>
    </div>
    <div class="inputFile" id="typeEchoSpeciesFile">
      <s:file name="typeEchoSpecies" required="true"
              key="echobase.label.import.typeEchoSpecies"/>

    </div>
  </fieldset>
  <br/>
  <s:submit action="configureFiles"
            value='%{getText("echobase.action.import")}'/>


</s:form>