/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importDb;

import fr.ifremer.echobase.InputFile;
import fr.ifremer.echobase.services.configurations.ImportDbConfiguration;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public class Configure
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Configure.class);
    protected ImportDbConfiguration model;

    public ImportDbConfiguration getModel() {
        if (this.model == null) {
            this.model = new ImportDbConfiguration(this.getLocale());
        }
        return this.model;
    }

    public void setInputFileName(String fileName) {
        this.getModel().getInput().setFileName(fileName);
    }

    public void setInput(File file) {
        this.getModel().getInput().setFile(file);
    }

    public void setInputContentType(String contentType) {
        this.getModel().getInput().setContentType(contentType);
    }

    public String input() throws Exception {
        this.getEchoBaseSession().setImportDbConfiguration(null);
        return "input";
    }

    public String execute() throws Exception {
        ImportDbConfiguration configuration = this.getModel();
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-importDb-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary((File)dataDirectory);
        configuration.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Temporary directory to use : " + dataDirectory));
        }
        InputFile input = configuration.getInput();
        this.copyFile(input, dataDirectory);
        this.getEchoBaseSession().setImportDbConfiguration(configuration);
        return "success";
    }
}

