/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui;

import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.services.ImportDataConfiguration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EchoBaseSession {
    private static final Log log = LogFactory.getLog(EchoBaseSession.class);
    protected static final String PROPERTY_ECHO_BASE_USER = "echobaseUser";
    protected static final String PROPERTY_IMPORT_DATA_CONFIGURATION = "importDataConfiguration";
    protected Map<String, Object> store = new TreeMap();

    public EchoBaseUser getEchoBaseUser() {
        return (EchoBaseUser)this.get(PROPERTY_ECHO_BASE_USER, EchoBaseUser.class);
    }

    public void setEchoBaseUser(EchoBaseUser echoBaseUser) {
        this.set(PROPERTY_ECHO_BASE_USER, (Object)echoBaseUser);
    }

    public ImportDataConfiguration getImportDataConfiguration() {
        return (ImportDataConfiguration)this.get(PROPERTY_IMPORT_DATA_CONFIGURATION, ImportDataConfiguration.class);
    }

    public void setImportDataConfiguration(ImportDataConfiguration configuration) {
        this.set(PROPERTY_IMPORT_DATA_CONFIGURATION, (Object)configuration);
    }

    public Object remove(String key) {
        Object remove = this.store.remove(key);
        if (log.isInfoEnabled()) {
            log.info((Object)("Remove from user session data [" + key + "] = " + remove));
        }
        return remove;
    }

    public boolean contains(String key) {
        boolean result = this.store.containsKey(key);
        return result;
    }

    protected <T> T get(String key, Class<T> type) {
        Object o = this.store.get(key);
        if (o != null && !type.isInstance(o)) {
            throw new ClassCastException("parameter " + key + " should be of type " + type.getName() + " but was " + o.getClass().getName());
        }
        return (T)o;
    }

    protected void set(String key, Object value) {
        if (value == null) {
            this.remove(key);
        } else {
            this.store.put(key, value);
            if (log.isInfoEnabled()) {
                log.info((Object)("Set in user session data [" + key + "] = " + value));
            }
        }
    }
}

