/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ExportSqlResult.java 80 2011-11-14 15:09:26Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/trunk/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/export/ExportSqlResult.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.export;

import fr.ifremer.echobase.EchoBaseTechnicalException;
import fr.ifremer.echobase.services.ExportSqlService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;

/**
 * Load export sql result fragment page.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class ExportSqlResult extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Sql request to execute. */
    protected String sql;

    /** Default file name for export. */
    protected String fileName;

    /** names of columns from the executed sql request. */
    protected String[] columnNames;

    public String getSql() {
        return sql;
    }

    public String[] getColumnNames() {
        return columnNames;
    }

    public String getFileName() {
        return fileName;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    @Override
    public String execute() throws Exception {

        // obtain columNames from the request
        ExportSqlService service = newService(ExportSqlService.class);

        try {
            columnNames = service.getColumnNames(sql);
        } catch (EchoBaseTechnicalException e) {
            //TODO add a real nice message
            addActionError(e.getMessage());
        }

        // create default file name

        fileName = "export.csv";
        return SUCCESS;
    }
}
