/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ExportSql.java 55 2011-11-13 22:22:54Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/export/ExportSql.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.export;

import fr.ifremer.echobase.entities.ExportQuery;
import fr.ifremer.echobase.entities.ExportQueryImpl;
import fr.ifremer.echobase.services.ExportSqlService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.Map;

/**
 * Load export sql main page.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class ExportSql extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** All available queries from database. */
    protected Map<String, String> queries;

    /** Selected query loaded from database if his id is not empty. */
    protected ExportQuery query;

    public ExportQuery getQuery() {
        if (query == null) {
            query = new ExportQueryImpl();
        }
        return query;
    }

    public Map<String, String> getQueries() {
        return queries;
    }

    public Map<String, String> getTableNames() {
        return queries;
    }

    @Override
    public String execute() throws Exception {
        ExportSqlService service = newService(ExportSqlService.class);

        Collection<ExportQuery> sqlQueries = service.getQueries();
        queries = sortAndDecorate(sqlQueries, null);

        if (sqlQueries.isEmpty()) {
            // no query saved
            addActionMessage(_("echobase.info.no.sqlQuery.saved"));
        }

        String selectedQueryId = getQuery().getTopiaId();

        if (StringUtils.isEmpty(selectedQueryId)) {

            // no query selected
            addActionMessage(_("echobase.info.no.sqlQuery.selected"));
        } else {

            // load query from database
            query = service.getQueryById(selectedQueryId);
        }
        return SUCCESS;
    }

}
