/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: LoadEntities.java 55 2011-11-13 22:22:54Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/dbeditor/LoadEntities.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.meta.ColumnMeta;
import fr.ifremer.echobase.entities.meta.DbMeta;
import fr.ifremer.echobase.entities.meta.TableMeta;
import fr.ifremer.echobase.services.DbEditorService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaEntity;

import java.util.List;
import java.util.Map;

import static org.nuiton.i18n.I18n.l_;

/**
 * To load the db editor pages.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class LoadEntities extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Name of the table to load. */
    protected String tableName;

    /** All tables availables */
    protected Map<String, String> tableNames;

    /** Metas of the table */
    protected TableMeta tableMeta;

    public String getTableName() {
        return tableName;
    }

    public Map<String, String> getTableNames() {
        return tableNames;
    }

    public List<ColumnMeta> getColumnMetas() {
        return tableMeta.getColumns();
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public String execute() throws Exception {
        tableNames = Maps.newTreeMap();
        DbMeta dbMeta = getEchoBaseApplicationContext().getDbMeta();
        for (TableMeta tableMeta : dbMeta) {
            String name = tableMeta.getName();
            String i18nKey = tableMeta.getI18nKey();
            tableNames.put(name, l_(getLocale(), i18nKey));
        }
        if (StringUtils.isEmpty(tableName)) {

            // no table selected
            addActionMessage(_("echobase.info.no.table.selected"));
        } else {

            // load table metas
            DbEditorService dbEditorService = newService(DbEditorService.class);
            tableMeta = dbEditorService.getTableMetas(tableName);
        }
        return SUCCESS;
    }

    public String getEditType(ColumnMeta meta) {
        Class<?> type = meta.getType();
        String editType="text";
        if (boolean.class.equals(type)) {
            editType = "checkbox";
        } else if (TopiaEntity.class.isAssignableFrom(type)) {
            editType = "select";
        }
        return editType;
    }

    public String getFormatter(ColumnMeta meta) {
        Class<?> type = meta.getType();
        String editType="'string'";
        if (boolean.class.equals(type)) {
            editType = "'checkbox'";
        }  else if (TopiaEntity.class.isAssignableFrom(type)) {
            editType = "'formatEntityLabel'";
        }
        return editType;
    }
}
