/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ImportAction.java 35 2011-11-11 02:13:58Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/ImportAction.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions;

import fr.ifremer.echobase.entities.Voyage;
import fr.ifremer.echobase.services.VoyageService;
import fr.ifremer.echobase.services.models.ImportModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;
import java.util.Map;

/**
 * Action to manage imports
 *
 * @author sletellier <letellier@codelutin.com>
 * @since 0.1
 */
public class ImportAction extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    protected static final Log log = LogFactory.getLog(ImportAction.class);

    protected ImportModel importModel;

    protected Map<String, String> voyages;

    public ImportModel getImportModel() {
        if (importModel == null) {
            importModel = new ImportModel();
        }
        return importModel;
    }

    public String getSelectedVoyageId() {
        String selectedVoyageId = getImportModel().getSelectedVoyageId();
        return selectedVoyageId;
    }

    public void setSelectedVoyageId(String selectedVoyageId) {
        VoyageService service = newService(VoyageService.class);
        Voyage selectedVoyage = service.getVoyageById(selectedVoyageId);
        getImportModel().setSelectedVoyage(selectedVoyage);
    }

    public Map<String, String> getVoyages() {
        return voyages;
    }

    @Override
    public String input() throws Exception {

        VoyageService service = newService(VoyageService.class);
        List<Voyage> allVoyages = service.getVoyages();
        voyages = sortAndDecorate(allVoyages, null);

        return INPUT;
    }

    @Override
    public String execute() throws Exception {
        log.info("Will import : " + importModel.toString());
        return SUCCESS;
    }

    @Override
    public void validate() {
        //FIXME : do a real validation with a xml validation file.
        if (!importModel.validate()) {
            addActionError(_("echobase.error.importArgument"));
        }
    }
}
