/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.persistence.entity;

import fr.ifremer.coselmar.persistence.DaoUtils;
import fr.ifremer.coselmar.persistence.entity.AbstractDocumentTopiaDao;
import fr.ifremer.coselmar.persistence.entity.CoselmarUser;
import fr.ifremer.coselmar.persistence.entity.Document;
import fr.ifremer.coselmar.persistence.entity.DocumentPrivacy;
import java.util.HashMap;
import java.util.List;
import org.nuiton.topia.persistence.internal.AbstractTopiaDao;

public class DocumentTopiaDao
extends AbstractDocumentTopiaDao<Document> {
    public List<Document> findAllContainingAllKeywords(List<String> keywords) {
        AbstractTopiaDao.InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep queryBuilder = this.newQueryBuilder();
        for (String keyword : keywords) {
            queryBuilder.addContains("keywords", (Object)keyword);
        }
        List documents = queryBuilder.findAll();
        return documents;
    }

    public List<Document> findAllFilterByUser(CoselmarUser currentUser, List<String> keywords) {
        StringBuilder hqlBuilder = new StringBuilder("FROM " + Document.class.getName() + " D");
        HashMap<String, Object> args = new HashMap<String, Object>();
        String privacyPublicCondition = DaoUtils.getQueryForAttributeEquals("D", "privacy", args, (Object)DocumentPrivacy.PUBLIC, "");
        hqlBuilder.append(" WHERE ( " + privacyPublicCondition);
        String privacyPrivateCondition = DaoUtils.getQueryForAttributeEquals("D", "privacy", args, (Object)DocumentPrivacy.PRIVATE, "");
        String ownerCondition = DaoUtils.andAttributeEquals("D", "owner", args, currentUser);
        hqlBuilder.append(" OR ( " + privacyPrivateCondition + " " + ownerCondition + " ) )");
        if (keywords != null) {
            for (String keyword : keywords) {
                String containsKeyword = DaoUtils.andAttributeContains("D", "keywords", args, keyword);
                hqlBuilder.append(containsKeyword);
            }
        }
        List documents = this.forHql(hqlBuilder.toString(), args).findAll();
        return documents;
    }
}

