/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml;

import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.StreamException;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.AbstractXmlDriver;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.XomReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import nu.xom.ValidityException;

public class XomDriver
extends AbstractXmlDriver {
    private final Builder builder;

    public XomDriver() {
        this(new Builder());
    }

    public XomDriver(Builder builder) {
        this(builder, new XmlFriendlyReplacer());
    }

    public XomDriver(XmlFriendlyReplacer replacer) {
        this(new Builder(), replacer);
    }

    public XomDriver(Builder builder, XmlFriendlyReplacer replacer) {
        super(replacer);
        this.builder = builder;
    }

    protected Builder getBuilder() {
        return this.builder;
    }

    public HierarchicalStreamReader createReader(Reader text) {
        try {
            Document document = this.builder.build(text);
            return new XomReader(document, this.xmlFriendlyReplacer());
        }
        catch (ValidityException e) {
            throw new StreamException(e);
        }
        catch (ParsingException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    public HierarchicalStreamReader createReader(InputStream in) {
        try {
            Document document = this.builder.build(in);
            return new XomReader(document, this.xmlFriendlyReplacer());
        }
        catch (ValidityException e) {
            throw new StreamException(e);
        }
        catch (ParsingException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, this.xmlFriendlyReplacer());
    }

    public HierarchicalStreamWriter createWriter(OutputStream out) {
        return new PrettyPrintWriter((Writer)new OutputStreamWriter(out), this.xmlFriendlyReplacer());
    }
}

