/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontProgram;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.outlet.FontFactoryException;

/**
 * A generic converter from {@link IFont} to a {@link PDFont}.
 * 
 */
public class FontConverterCwt2Pdf extends CommonFontConverter {

	public FontConverterCwt2Pdf(IFont font) {
		super(font);
	}

	@Override
	public PDFont getPdFont() throws FontFactoryException {
		IFontProgram fp = getCwtFont().getFontProgram();
		FontConverterPlatform2Pdf converter = null;
		if ("TrueType".equals(getCwtFont().getFontType())) {
			converter = new FontConverterTrueType2Pdf(getCwtFont());
		} else if ("Type1".equals(getCwtFont().getFontType())) {
			converter = new FontConverterType12Pdf(getCwtFont());
		}
		if (converter == null) {
			return null;
		}
		converter.setEmbed(isEmbed());
		return converter.getPdFont();
	}

}
