/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;

import de.intarsys.pdf.pd.PDCSLab;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;

/**
 * 
 */
public class AwtCSLab extends AwtCSCIEBased {

	class LabColorSpace extends ColorSpace {
		LabColorSpace() {
			super(ColorSpace.TYPE_3CLR, 3);
		}

		public float[] fromCIEXYZ(float[] colorvalue) {
			throw new UnsupportedOperationException();
		}

		public float[] fromRGB(float[] rgbvalue) {
			throw new UnsupportedOperationException();
		}

		public float[] toCIEXYZ(float[] colorvalue) {
			float l;
			float m;
			float n;
			float x;
			float y;
			float z;

			float[] whitePoint = myPDColorSpace().getWhitePoint();
			l = ((colorvalue[0] + 16) / 116) + (colorvalue[1] / 500);
			m = ((colorvalue[0] + 16) / 116);
			n = ((colorvalue[0] + 16) / 116) - (colorvalue[2] / 200);
			x = whitePoint[0]
					* (l >= 6.0f / 29 ? (float) Math.pow(l, 3) : (108.0f / 841)
							* (l - (4.0f / 29)));
			y = whitePoint[1]
					* (m >= 6.0f / 29 ? (float) Math.pow(m, 3) : (108.0f / 841)
							* (m - (4.0f / 29)));
			z = whitePoint[2]
					* (n >= 6.0f / 29 ? (float) Math.pow(n, 3) : (108.0f / 841)
							* (n - (4.0f / 29)));
			/*
			 * above formula should yield values in the valid range; it might
			 * not because of float imprecision
			 */
			return new float[] { Math.max(Math.min(x, 1), 0),
					Math.max(Math.min(y, 1), 0), Math.max(Math.min(z, 1), 0) };
		}

		public float[] toRGB(float[] colorvalue) {
			return ColorSpace.getInstance(ColorSpace.CS_CIEXYZ).toRGB(
					toCIEXYZ(colorvalue));
		}
	}

	public AwtCSLab(PDColorSpace pdColorSpace) {
		super(pdColorSpace);
	}

	@Override
	protected ColorSpace createColorSpace() {
		return new LabColorSpace();
	}

	@Override
	public ColorModel getColorModel(PDImage pdImage) {
		return new ComponentColorModel(getColorSpace(), false, false,
				Transparency.OPAQUE, DataBuffer.TYPE_BYTE);
	}

	@Override
	public int getNumComponents() {
		return 3;
	}

	protected PDCSLab myPDColorSpace() {
		return (PDCSLab) getPDColorSpace();
	}

}
