/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.filebuffer;

import de.huxhorn.sulky.buffers.BasicBufferIterator;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.Dispose;
import de.huxhorn.sulky.buffers.DisposeOperation;
import de.huxhorn.sulky.buffers.ElementProcessor;
import de.huxhorn.sulky.buffers.FileBuffer;
import de.huxhorn.sulky.buffers.Reset;
import de.huxhorn.sulky.buffers.SetOperation;
import de.huxhorn.sulky.codec.Codec;
import de.huxhorn.sulky.codec.filebuffer.DataStrategy;
import de.huxhorn.sulky.codec.filebuffer.DefaultDataStrategy;
import de.huxhorn.sulky.codec.filebuffer.DefaultFileHeaderStrategy;
import de.huxhorn.sulky.codec.filebuffer.DefaultIndexStrategy;
import de.huxhorn.sulky.codec.filebuffer.FileHeader;
import de.huxhorn.sulky.codec.filebuffer.FileHeaderStrategy;
import de.huxhorn.sulky.codec.filebuffer.IndexStrategy;
import de.huxhorn.sulky.codec.filebuffer.MetaData;
import de.huxhorn.sulky.codec.filebuffer.SparseDataStrategy;
import de.huxhorn.sulky.io.IOUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodecFileBuffer<E>
implements FileBuffer<E>,
SetOperation<E>,
DisposeOperation {
    private final Logger logger = LoggerFactory.getLogger(CodecFileBuffer.class);
    private final ReadWriteLock readWriteLock;
    private File dataFile;
    private File indexFile;
    private static final String INDEX_EXTENSION = ".index";
    private Map<String, String> preferredMetaData;
    private Codec<E> codec;
    private List<ElementProcessor<E>> elementProcessors;
    private FileHeaderStrategy fileHeaderStrategy;
    private int magicValue;
    private FileHeader fileHeader;
    private boolean preferredSparse;
    private DataStrategy<E> dataStrategy;
    private IndexStrategy indexStrategy = new DefaultIndexStrategy();

    public CodecFileBuffer(int magicValue, boolean sparse, Map<String, String> preferredMetaData, Codec<E> codec, File dataFile, File indexFile) {
        this(magicValue, sparse, preferredMetaData, codec, dataFile, indexFile, new DefaultFileHeaderStrategy());
    }

    public CodecFileBuffer(int magicValue, boolean preferredSparse, Map<String, String> preferredMetaData, Codec<E> codec, File dataFile, File indexFile, FileHeaderStrategy fileHeaderStrategy) {
        this.magicValue = magicValue;
        this.fileHeaderStrategy = fileHeaderStrategy;
        this.readWriteLock = new ReentrantReadWriteLock(true);
        this.preferredSparse = preferredSparse;
        if (preferredMetaData != null) {
            preferredMetaData = new HashMap<String, String>(preferredMetaData);
        }
        if (preferredMetaData != null) {
            this.preferredMetaData = new HashMap<String, String>(preferredMetaData);
        }
        this.codec = codec;
        this.setDataFile(dataFile);
        if (indexFile == null) {
            File parent = dataFile.getParentFile();
            String indexName = dataFile.getName();
            int dotIndex = indexName.lastIndexOf(46);
            if (dotIndex > 0) {
                indexName = indexName.substring(0, dotIndex);
            }
            indexName = indexName + INDEX_EXTENSION;
            indexFile = new File(parent, indexName);
        }
        this.setIndexFile(indexFile);
        if (!this.initFilesIfNecessary()) {
            this.validateHeader();
        }
    }

    private void validateHeader() {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            this.fileHeader = null;
            FileHeader header = this.fileHeaderStrategy.readFileHeader(this.dataFile);
            if (header == null) {
                throw new IllegalArgumentException("Could not read file header from file '" + this.dataFile.getAbsolutePath() + "'. File isn't compatible.");
            }
            if (header.getMagicValue() != this.magicValue) {
                throw new IllegalArgumentException("Wrong magic value. Expected 0x" + Integer.toHexString(this.magicValue) + " but was " + Integer.toHexString(header.getMagicValue()) + "!");
            }
            if (this.dataFile.length() > header.getDataOffset() && !this.indexFile.exists()) {
                throw new IllegalArgumentException("dataFile contains data but indexFile " + this.indexFile.getAbsolutePath() + " is not valid!");
            }
            this.setFileHeader(header);
        }
        catch (IOException ex) {
            IOUtilities.interruptIfNecessary((Throwable)ex);
            throw new IllegalArgumentException("Could not read magic value from file '" + this.dataFile.getAbsolutePath() + "'!", ex);
        }
        finally {
            lock.unlock();
        }
    }

    public Codec<E> getCodec() {
        return this.codec;
    }

    public void setCodec(Codec<E> codec) {
        this.codec = codec;
    }

    public List<ElementProcessor<E>> getElementProcessors() {
        if (this.elementProcessors == null) {
            return null;
        }
        return Collections.unmodifiableList(this.elementProcessors);
    }

    public void setElementProcessors(List<ElementProcessor<E>> elementProcessors) {
        if (elementProcessors != null) {
            elementProcessors = elementProcessors.size() == 0 ? null : new ArrayList<ElementProcessor<ElementProcessor<ElementProcessor<ElementProcessor<E>>>>>(elementProcessors);
        }
        this.elementProcessors = elementProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initFilesIfNecessary() {
        if (!this.dataFile.exists() || this.dataFile.length() < (long)this.fileHeaderStrategy.getMinimalSize()) {
            IOException t = null;
            boolean dataDeleted = false;
            boolean indexDeleted = false;
            Lock lock = this.readWriteLock.writeLock();
            lock.lock();
            try {
                dataDeleted = this.dataFile.delete();
                this.setFileHeader(this.fileHeaderStrategy.writeFileHeader(this.dataFile, this.magicValue, this.preferredMetaData, this.preferredSparse));
                indexDeleted = this.indexFile.delete();
            }
            catch (IOException e) {
                t = e;
            }
            finally {
                lock.unlock();
            }
            if (!indexDeleted && this.logger.isDebugEnabled()) {
                this.logger.debug("Couldn't delete index file {}.", (Object)this.indexFile.getAbsolutePath());
            }
            if (!dataDeleted && this.logger.isDebugEnabled()) {
                this.logger.debug("Couldn't delete data file {}.", (Object)this.dataFile.getAbsolutePath());
            }
            if (t != null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while initializing files!", (Throwable)t);
                }
                IOUtilities.interruptIfNecessary((Throwable)t);
                return false;
            }
            return true;
        }
        return false;
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public Map<String, String> getPreferredMetaData() {
        if (this.preferredMetaData == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.preferredMetaData);
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        Throwable throwable;
        block9: {
            long l;
            Lock lock;
            RandomAccessFile raf;
            block8: {
                raf = null;
                lock = this.readWriteLock.readLock();
                lock.lock();
                if (this.indexFile.canRead()) break block8;
                long l2 = 0L;
                IOUtilities.closeQuietly(raf);
                lock.unlock();
                return l2;
            }
            try {
                raf = new RandomAccessFile(this.indexFile, "r");
                l = this.indexStrategy.getSize(raf);
            }
            catch (Throwable e) {
                try {
                    throwable = e;
                    break block9;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    IOUtilities.closeQuietly(raf);
                    lock.unlock();
                }
            }
            IOUtilities.closeQuietly((RandomAccessFile)raf);
            lock.unlock();
            return l;
        }
        if (throwable != null) {
            IOUtilities.interruptIfNecessary((Throwable)throwable);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Couldn't retrieve size!", throwable);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(long index) {
        Throwable throwable;
        block15: {
            E e;
            Lock lock;
            RandomAccessFile randomSerializeFile;
            RandomAccessFile randomSerializeIndexFile;
            block14: {
                randomSerializeIndexFile = null;
                randomSerializeFile = null;
                lock = this.readWriteLock.readLock();
                lock.lock();
                throwable = null;
                if (this.dataFile.canRead() && this.indexFile.canRead()) break block14;
                E e2 = null;
                IOUtilities.closeQuietly(randomSerializeFile);
                IOUtilities.closeQuietly(randomSerializeIndexFile);
                lock.unlock();
                return e2;
            }
            try {
                randomSerializeIndexFile = new RandomAccessFile(this.indexFile, "r");
                randomSerializeFile = new RandomAccessFile(this.dataFile, "r");
                e = this.dataStrategy.get(index, randomSerializeIndexFile, randomSerializeFile, this.codec, this.indexStrategy);
            }
            catch (Throwable e3) {
                try {
                    throwable = e3;
                    break block15;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    IOUtilities.closeQuietly(randomSerializeFile);
                    IOUtilities.closeQuietly(randomSerializeIndexFile);
                    lock.unlock();
                }
            }
            IOUtilities.closeQuietly((RandomAccessFile)randomSerializeFile);
            IOUtilities.closeQuietly((RandomAccessFile)randomSerializeIndexFile);
            lock.unlock();
            return e;
        }
        if (throwable != null) {
            if (throwable instanceof ClassNotFoundException || throwable instanceof InvalidClassException) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Couldn't deserialize object at index {}!\n{}", (Object)index, (Object)throwable);
                }
            } else if (throwable instanceof ClassCastException) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Couldn't cast deserialized object at index {}!\n{}", (Object)index, (Object)throwable);
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("Couldn't retrieve element at index {}!", (Object)index, (Object)throwable);
            }
            IOUtilities.interruptIfNecessary((Throwable)throwable);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E element) {
        IOException throwable;
        Lock lock;
        RandomAccessFile randomDataFile;
        RandomAccessFile randomIndexFile;
        block7: {
            this.initFilesIfNecessary();
            randomIndexFile = null;
            randomDataFile = null;
            lock = this.readWriteLock.writeLock();
            lock.lock();
            throwable = null;
            try {
                randomIndexFile = new RandomAccessFile(this.indexFile, "rw");
                randomDataFile = new RandomAccessFile(this.dataFile, "rw");
                this.dataStrategy.add(element, randomIndexFile, randomDataFile, this.codec, this.indexStrategy);
                List<ElementProcessor<E>> localProcessors = this.elementProcessors;
                if (localProcessors == null) break block7;
                for (ElementProcessor<E> current : this.elementProcessors) {
                    current.processElement(element);
                }
            }
            catch (IOException e) {
                try {
                    throwable = e;
                }
                catch (Throwable throwable2) {
                    IOUtilities.closeQuietly(randomDataFile);
                    IOUtilities.closeQuietly(randomIndexFile);
                    lock.unlock();
                    throw throwable2;
                }
                IOUtilities.closeQuietly(randomDataFile);
                IOUtilities.closeQuietly((RandomAccessFile)randomIndexFile);
                lock.unlock();
            }
        }
        IOUtilities.closeQuietly((RandomAccessFile)randomDataFile);
        IOUtilities.closeQuietly((RandomAccessFile)randomIndexFile);
        lock.unlock();
        if (throwable != null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Couldn't write element!", (Throwable)throwable);
            }
            IOUtilities.interruptIfNecessary((Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<E> elements) {
        block8: {
            Throwable throwable;
            Lock lock;
            RandomAccessFile randomDataFile;
            RandomAccessFile randomIndexFile;
            block7: {
                if (elements == null) break block8;
                this.initFilesIfNecessary();
                int newElementCount = elements.size();
                if (newElementCount <= 0) break block8;
                randomIndexFile = null;
                randomDataFile = null;
                lock = this.readWriteLock.writeLock();
                lock.lock();
                throwable = null;
                try {
                    randomIndexFile = new RandomAccessFile(this.indexFile, "rw");
                    randomDataFile = new RandomAccessFile(this.dataFile, "rw");
                    this.dataStrategy.addAll(elements, randomIndexFile, randomDataFile, this.codec, this.indexStrategy);
                    if (this.elementProcessors == null) break block7;
                    for (ElementProcessor<E> current : this.elementProcessors) {
                        current.processElements(elements);
                    }
                }
                catch (Throwable e) {
                    try {
                        throwable = e;
                    }
                    catch (Throwable throwable2) {
                        IOUtilities.closeQuietly(randomDataFile);
                        IOUtilities.closeQuietly(randomIndexFile);
                        lock.unlock();
                        throw throwable2;
                    }
                    IOUtilities.closeQuietly(randomDataFile);
                    IOUtilities.closeQuietly((RandomAccessFile)randomIndexFile);
                    lock.unlock();
                }
            }
            IOUtilities.closeQuietly((RandomAccessFile)randomDataFile);
            IOUtilities.closeQuietly((RandomAccessFile)randomIndexFile);
            lock.unlock();
            if (throwable != null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Couldn't write element!", throwable);
                }
                IOUtilities.interruptIfNecessary((Throwable)throwable);
            }
        }
    }

    public void addAll(E[] elements) {
        this.addAll(Arrays.asList(elements));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        IOException t = null;
        boolean indexDeleted = false;
        boolean dataDeleted = false;
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            indexDeleted = this.indexFile.delete();
            dataDeleted = this.dataFile.delete();
            this.fileHeaderStrategy.writeFileHeader(this.dataFile, this.magicValue, this.preferredMetaData, this.preferredSparse);
            if (this.elementProcessors != null) {
                for (ElementProcessor<E> current : this.elementProcessors) {
                    Reset.reset(current);
                }
            }
        }
        catch (IOException e) {
            t = e;
        }
        finally {
            lock.unlock();
        }
        if (!indexDeleted && this.logger.isDebugEnabled()) {
            this.logger.debug("Couldn't delete index file {}.", (Object)this.indexFile.getAbsolutePath());
        }
        if (!dataDeleted && this.logger.isDebugEnabled()) {
            this.logger.debug("Couldn't delete data file {}.", (Object)this.dataFile.getAbsolutePath());
        }
        if (t != null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while resetting file!", (Throwable)t);
            }
            IOUtilities.interruptIfNecessary((Throwable)t);
        }
    }

    public boolean isFull() {
        return false;
    }

    public Iterator<E> iterator() {
        return new BasicBufferIterator((Buffer)this);
    }

    private void setDataFile(File dataFile) {
        this.prepareFile(dataFile);
        this.dataFile = dataFile;
    }

    private void setIndexFile(File indexFile) {
        this.prepareFile(indexFile);
        this.indexFile = indexFile;
    }

    private void prepareFile(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            if (parent.mkdirs() && this.logger.isDebugEnabled()) {
                this.logger.debug("Created directory {}.", (Object)parent.getAbsolutePath());
            }
            if (!parent.isDirectory()) {
                throw new IllegalArgumentException(parent.getAbsolutePath() + " is not a directory!");
            }
            if (file.isFile() && !file.canWrite()) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not writable!");
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("CodecFileBuffer[");
        result.append("fileHeader=");
        result.append(this.fileHeader);
        result.append(", ");
        result.append("preferredMetaData=").append(this.preferredMetaData);
        result.append(", ");
        result.append("dataFile=");
        if (this.dataFile == null) {
            result.append("null");
        } else {
            result.append("\"").append(this.dataFile.getAbsolutePath()).append("\"");
        }
        result.append(", ");
        result.append("indexFile=");
        if (this.indexFile == null) {
            result.append("null");
        } else {
            result.append("\"").append(this.indexFile.getAbsolutePath()).append("\"");
        }
        result.append(", ");
        result.append("codec=").append(this.codec);
        result.append("]");
        return result.toString();
    }

    public void dispose() {
        if (this.elementProcessors != null) {
            for (ElementProcessor<E> current : this.elementProcessors) {
                Dispose.dispose(current);
            }
        }
    }

    public boolean isDisposed() {
        return false;
    }

    private void setFileHeader(FileHeader fileHeader) {
        MetaData metaData = fileHeader.getMetaData();
        this.dataStrategy = metaData.isSparse() ? new SparseDataStrategy() : new DefaultDataStrategy();
        this.fileHeader = fileHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(long index, E element) {
        boolean result;
        IOException throwable;
        Lock lock;
        RandomAccessFile randomDataFile;
        RandomAccessFile randomIndexFile;
        block7: {
            this.initFilesIfNecessary();
            randomIndexFile = null;
            randomDataFile = null;
            lock = this.readWriteLock.writeLock();
            lock.lock();
            throwable = null;
            result = false;
            try {
                randomIndexFile = new RandomAccessFile(this.indexFile, "rw");
                randomDataFile = new RandomAccessFile(this.dataFile, "rw");
                result = this.dataStrategy.set(index, element, randomIndexFile, randomDataFile, this.codec, this.indexStrategy);
                List<ElementProcessor<E>> localProcessors = this.elementProcessors;
                if (localProcessors == null) break block7;
                for (ElementProcessor<E> current : this.elementProcessors) {
                    current.processElement(element);
                }
            }
            catch (IOException e) {
                try {
                    throwable = e;
                }
                catch (Throwable throwable2) {
                    IOUtilities.closeQuietly(randomDataFile);
                    IOUtilities.closeQuietly(randomIndexFile);
                    lock.unlock();
                    throw throwable2;
                }
                IOUtilities.closeQuietly(randomDataFile);
                IOUtilities.closeQuietly((RandomAccessFile)randomIndexFile);
                lock.unlock();
            }
        }
        IOUtilities.closeQuietly((RandomAccessFile)randomDataFile);
        IOUtilities.closeQuietly((RandomAccessFile)randomIndexFile);
        lock.unlock();
        if (throwable != null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Couldn't write element!", (Throwable)throwable);
            }
            IOUtilities.interruptIfNecessary((Throwable)throwable);
        }
        return result;
    }

    public boolean isSetSupported() {
        return this.dataStrategy != null && this.dataStrategy.isSetSupported();
    }
}

