/*
 * Decompiled with CFR 0.152.
 */
package org.geojson.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import org.geojson.LngLatAlt;

public class LngLatAltDeserializer
extends JsonDeserializer<LngLatAlt> {
    public LngLatAlt deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.isExpectedStartArrayToken()) {
            return this.deserializeArray(jp, ctxt);
        }
        throw ctxt.mappingException(LngLatAlt.class);
    }

    protected LngLatAlt deserializeArray(JsonParser jp, DeserializationContext ctxt) throws IOException {
        LngLatAlt node = new LngLatAlt();
        node.setLongitude(this.extractDouble(jp, ctxt, false));
        node.setLatitude(this.extractDouble(jp, ctxt, false));
        node.setAltitude(this.extractDouble(jp, ctxt, true));
        ArrayList<Double> additionalElementsList = new ArrayList<Double>();
        while (jp.hasCurrentToken() && jp.getCurrentToken() != JsonToken.END_ARRAY) {
            double element = this.extractDouble(jp, ctxt, true);
            if (Double.isNaN(element)) continue;
            additionalElementsList.add(element);
        }
        double[] additionalElements = new double[additionalElementsList.size()];
        for (int i = 0; i < additionalElements.length; ++i) {
            additionalElements[i] = (Double)additionalElementsList.get(i);
        }
        node.setAdditionalElements(additionalElements);
        return node;
    }

    private double extractDouble(JsonParser jp, DeserializationContext ctxt, boolean optional) throws IOException {
        JsonToken token = jp.nextToken();
        if (token == null) {
            if (optional) {
                return Double.NaN;
            }
            throw ctxt.mappingException("Unexpected end-of-input when binding data into LngLatAlt");
        }
        switch (token) {
            case END_ARRAY: {
                if (optional) {
                    return Double.NaN;
                }
                throw ctxt.mappingException("Unexpected end-of-input when binding data into LngLatAlt");
            }
            case VALUE_NUMBER_FLOAT: {
                return jp.getDoubleValue();
            }
            case VALUE_NUMBER_INT: {
                return jp.getLongValue();
            }
            case VALUE_STRING: {
                return jp.getValueAsDouble();
            }
        }
        throw ctxt.mappingException("Unexpected token (" + token.name() + ") when binding data into LngLatAlt");
    }
}

