/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.injection;

import de.akquinet.jbosscc.needle.NeedleContext;
import de.akquinet.jbosscc.needle.injection.InjectionConfiguration;
import de.akquinet.jbosscc.needle.injection.InjectionProvider;
import de.akquinet.jbosscc.needle.injection.InjectionTargetInformation;
import de.akquinet.jbosscc.needle.reflection.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestcaseInjectionProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TestcaseInjectionProcessor.class);

    public void process(NeedleContext context, InjectionConfiguration configuration) {
        Set<Class<? extends Annotation>> supportedAnnotations = configuration.getSupportedAnnotations();
        for (Class<? extends Annotation> supportedAnnotation : supportedAnnotations) {
            this.processAnnotation(context, configuration, supportedAnnotation);
        }
    }

    private void processAnnotation(NeedleContext context, InjectionConfiguration configuration, Class<? extends Annotation> annotation) {
        List<Field> fields = context.getAnnotatedTestcaseFields(annotation);
        for (Field field : fields) {
            this.processField(context, configuration, field);
        }
    }

    private void processField(NeedleContext context, InjectionConfiguration configuration, Field field) {
        List<List<InjectionProvider<?>>> injectionProviderList = configuration.getInjectionProvider();
        InjectionTargetInformation injectionTargetInformation = new InjectionTargetInformation(field.getType(), field);
        for (List<InjectionProvider<?>> injectionProvider : injectionProviderList) {
            Map.Entry<Object, Object> injection = configuration.handleInjectionProvider(injectionProvider, injectionTargetInformation);
            if (injection == null) continue;
            Object contextObject = context.getInjectedObject(injection.getKey());
            Object injectedObject = contextObject != null ? contextObject : injection.getValue();
            try {
                ReflectionUtil.setField(field, context.getTest(), injectedObject);
                return;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

