/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class InjectionTargetInformation {
    private final Class<?> type;
    private final AccessibleObject accessibleObject;
    private final Annotation[] parameterAnnotations;

    private InjectionTargetInformation(Class<?> type, AccessibleObject accessibleObject, Annotation ... parameterAnnotations) {
        this.type = type;
        this.accessibleObject = accessibleObject;
        this.parameterAnnotations = parameterAnnotations;
    }

    public InjectionTargetInformation(Class<?> type, Field field) {
        this(type, field, new Annotation[0]);
    }

    public InjectionTargetInformation(Class<?> type, Method method, Annotation[] parameterAnnotations) {
        this(type, (AccessibleObject)method, parameterAnnotations);
    }

    public InjectionTargetInformation(Class<?> type, Constructor<?> constructor, Annotation[] parameterAnnotations) {
        this(type, (AccessibleObject)constructor, parameterAnnotations);
    }

    public Class<?> getType() {
        return this.type;
    }

    public Annotation[] getAnnotations() {
        Annotation[] accessibleObjectAnnotations = this.accessibleObject.getAnnotations();
        Annotation[] annotations = new Annotation[accessibleObjectAnnotations.length + this.parameterAnnotations.length];
        System.arraycopy(accessibleObjectAnnotations, 0, annotations, 0, accessibleObjectAnnotations.length);
        System.arraycopy(this.parameterAnnotations, 0, annotations, accessibleObjectAnnotations.length, this.parameterAnnotations.length);
        return annotations;
    }

    public AccessibleObject getAccessibleObject() {
        return this.accessibleObject;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public <T> T getAnnotation(Class<? extends Annotation> annotationClass) {
        Annotation annotation = this.accessibleObject.getAnnotation(annotationClass);
        if (annotation != null) {
            return (T)annotation;
        }
        for (Annotation parameterAnnoation : this.parameterAnnotations) {
            if (parameterAnnoation.annotationType() != annotationClass) continue;
            return (T)parameterAnnoation;
        }
        return null;
    }
}

