/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.injection;

import de.akquinet.jbosscc.needle.NeedleContext;
import de.akquinet.jbosscc.needle.annotation.InjectInto;
import de.akquinet.jbosscc.needle.annotation.InjectIntoMany;
import de.akquinet.jbosscc.needle.reflection.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionAnnotationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(InjectionAnnotationProcessor.class);

    public void process(NeedleContext context) {
        this.proccessInjectIntoMany(context);
        this.proccessInjectInto(context);
    }

    private void proccessInjectIntoMany(NeedleContext context) {
        Object testcase = context.getTest();
        List<Field> fieldsWithInjectIntoManyAnnotation = context.getAnnotatedTestcaseFields(InjectIntoMany.class);
        for (Field field : fieldsWithInjectIntoManyAnnotation) {
            Object sourceObject = ReflectionUtil.getFieldValue(testcase, field);
            InjectIntoMany injectIntoManyAnnotation = field.getAnnotation(InjectIntoMany.class);
            InjectInto[] value = injectIntoManyAnnotation.value();
            if (value.length == 0) {
                for (Object inejctedObject : context.getObjectsUnderTest()) {
                    this.injectByType(inejctedObject, sourceObject, field.getType());
                }
                continue;
            }
            for (InjectInto injectInto : value) {
                this.processInjectInto(context, field, sourceObject, injectInto);
            }
        }
    }

    private void proccessInjectInto(NeedleContext context) {
        Object testcase = context.getTest();
        List<Field> fields = context.getAnnotatedTestcaseFields(InjectInto.class);
        for (Field field : fields) {
            Object sourceObject = ReflectionUtil.getFieldValue(testcase, field);
            this.processInjectInto(context, field, sourceObject, field.getAnnotation(InjectInto.class));
        }
    }

    private void processInjectInto(NeedleContext context, Field field, Object sourceObject, InjectInto injectInto) {
        Object object = context.getObjectUnderTest(injectInto.targetComponentId());
        if (object != null) {
            if (injectInto.fieldName().equals("")) {
                this.injectByType(object, sourceObject, field.getType());
            } else {
                this.injectByFieldName(object, sourceObject, injectInto.fieldName());
            }
        } else {
            LOG.warn("could not inject component {} -  unknown object under test with id {}", sourceObject, (Object)injectInto.targetComponentId());
        }
    }

    private void injectByType(Object objectUnderTest, Object sourceObject, Class<?> type) {
        List<Field> fields = ReflectionUtil.getAllFieldsAssinableFrom(type, objectUnderTest.getClass());
        for (Field field : fields) {
            try {
                ReflectionUtil.setField(field, objectUnderTest, sourceObject);
            }
            catch (Exception e) {
                LOG.warn("could not inject into component " + objectUnderTest, (Throwable)e);
            }
        }
    }

    private void injectByFieldName(Object objectUnderTest, Object sourceObject, String fieldName) {
        try {
            ReflectionUtil.setField(fieldName, objectUnderTest, sourceObject);
        }
        catch (Exception e) {
            LOG.warn("could not inject into component " + objectUnderTest, (Throwable)e);
        }
    }
}

