/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.db;

import de.akquinet.jbosscc.needle.db.DatabaseTestcase;
import de.akquinet.jbosscc.needle.injection.InjectionProvider;
import de.akquinet.jbosscc.needle.injection.InjectionTargetInformation;
import de.akquinet.jbosscc.needle.injection.InjectionVerifier;
import javax.persistence.EntityManager;

class EntityManagerProvider
implements InjectionProvider<EntityManager> {
    private final DatabaseTestcase databaseTestcase;
    private final InjectionVerifier verifyer;

    public EntityManagerProvider(DatabaseTestcase databaseTestcase) {
        this.databaseTestcase = databaseTestcase;
        this.verifyer = new InjectionVerifier(){

            @Override
            public boolean verify(InjectionTargetInformation information) {
                return information.getType() == EntityManager.class;
            }
        };
    }

    @Override
    public EntityManager getInjectedObject(Class<?> type) {
        return this.databaseTestcase.getEntityManager();
    }

    @Override
    public boolean verify(InjectionTargetInformation injectionTargetInformation) {
        return this.verifyer.verify(injectionTargetInformation);
    }

    @Override
    public Object getKey(InjectionTargetInformation injectionTargetInformation) {
        return EntityManager.class;
    }
}

