/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.db;

import de.akquinet.jbosscc.needle.db.DatabaseTestcase;
import de.akquinet.jbosscc.needle.injection.InjectionProvider;
import de.akquinet.jbosscc.needle.injection.InjectionTargetInformation;
import de.akquinet.jbosscc.needle.injection.InjectionVerifier;
import javax.persistence.EntityManagerFactory;

class EntityManagerFactoryProvider
implements InjectionProvider<EntityManagerFactory> {
    private final DatabaseTestcase databaseTestcase;
    private InjectionVerifier verifier;

    EntityManagerFactoryProvider(DatabaseTestcase databaseTestcase) {
        this.databaseTestcase = databaseTestcase;
        this.verifier = new InjectionVerifier(){

            @Override
            public boolean verify(InjectionTargetInformation information) {
                return information.getType() == EntityManagerFactory.class;
            }
        };
    }

    @Override
    public EntityManagerFactory getInjectedObject(Class<?> type) {
        return this.databaseTestcase.getEntityManagerFactory();
    }

    @Override
    public boolean verify(InjectionTargetInformation injectionTargetInformation) {
        return this.verifier.verify(injectionTargetInformation);
    }

    @Override
    public Object getKey(InjectionTargetInformation injectionTargetInformation) {
        return EntityManagerFactory.class;
    }
}

