/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.Product;
import com.vaadin.pro.licensechecker.Util;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class VaadinComIntegration {
    private static final String BASE_URL = "https://vaadin.com/pro/validate-license";
    private static final String MANUAL_PRO_KEY_URL = "https://vaadin.com/pro/validate-license";

    ProKey openBrowserAndWaitForKey(Product product, Consumer<String> noKeyUrlHandler, int timeoutSeconds) {
        String uniqueId = UUID.randomUUID().toString();
        String loginUrl = VaadinComIntegration.constructUrl(uniqueId, product);
        noKeyUrlHandler.accept(loginUrl);
        try {
            return this.listenForProKey(new URL("https://vaadin.com/pro/validate-license/connect/" + uniqueId), timeoutSeconds);
        }
        catch (MalformedURLException e) {
            throw new LicenseException("Internal error: Invalid URL");
        }
    }

    public static String constructUrl(String uniqueId, Product product) {
        String url = "https://vaadin.com/pro/validate-license?productName=" + product.getName() + "&productVersion=" + product.getVersion();
        if (uniqueId != null) {
            url = url + "&connect=" + uniqueId;
        }
        return url;
    }

    ProKey listenForProKey(URL url, int timeoutSeconds) {
        Instant timeout = Instant.now().plusSeconds(timeoutSeconds);
        while (Instant.now().isBefore(timeout)) {
            block13: {
                ProKey proKey;
                block12: {
                    VaadinComIntegration.getLogger().debug("Polling server for pro key");
                    InputStream in = url.openStream();
                    try {
                        String data = Util.toString(in);
                        proKey = ProKey.fromJson(data);
                        if (in == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            break block13;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    in.close();
                }
                return proKey;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }
}

