/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.developer.StreamingAttachmentFeature;
import com.sun.xml.ws.encoding.ContentType;
import com.sun.xml.ws.encoding.DataSourceStreamingDataHandler;
import com.sun.xml.ws.encoding.MIMEPartStreamingDataHandler;
import com.sun.xml.ws.util.ByteArrayBuffer;
import com.sun.xml.ws.util.ByteArrayDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.jvnet.mimepull.MIMEMessage;
import org.jvnet.mimepull.MIMEPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MimeMultipartParser {
    private final String start;
    private final MIMEMessage message;
    private Attachment root;
    private final Map<String, Attachment> attachments = new HashMap<String, Attachment>();
    private boolean gotAll;

    public MimeMultipartParser(InputStream in, String contentType, StreamingAttachmentFeature feature) {
        ContentType ct = new ContentType(contentType);
        String boundary = ct.getParameter("boundary");
        if (boundary == null || boundary.equals("")) {
            throw new WebServiceException("MIME boundary parameter not found" + contentType);
        }
        this.message = feature != null ? new MIMEMessage(in, boundary, feature.getConfig()) : new MIMEMessage(in, boundary);
        String st = ct.getParameter("start");
        if (st != null && st.length() > 2 && st.charAt(0) == '<' && st.charAt(st.length() - 1) == '>') {
            st = st.substring(1, st.length() - 1);
        }
        this.start = st;
    }

    @Nullable
    public Attachment getRootPart() {
        if (this.root == null) {
            this.root = new PartAttachment(this.start != null ? this.message.getPart(this.start) : this.message.getPart(0));
        }
        return this.root;
    }

    @NotNull
    public Map<String, Attachment> getAttachmentParts() {
        if (!this.gotAll) {
            MIMEPart rootPart = this.start != null ? this.message.getPart(this.start) : this.message.getPart(0);
            List parts = this.message.getAttachments();
            for (MIMEPart part : parts) {
                if (part == rootPart) continue;
                PartAttachment attach = new PartAttachment(part);
                this.attachments.put(attach.getContentId(), attach);
            }
            this.gotAll = true;
        }
        return this.attachments;
    }

    @Nullable
    public Attachment getAttachmentPart(String contentId) throws IOException {
        Attachment attach = this.attachments.get(contentId);
        if (attach == null) {
            MIMEPart part = this.message.getPart(contentId);
            attach = new PartAttachment(part);
            this.attachments.put(contentId, attach);
        }
        return attach;
    }

    static class PartAttachment
    implements Attachment {
        final MIMEPart part;
        byte[] buf;

        PartAttachment(MIMEPart part) {
            this.part = part;
        }

        @NotNull
        public String getContentId() {
            return this.part.getContentId();
        }

        @NotNull
        public String getContentType() {
            return this.part.getContentType();
        }

        public byte[] asByteArray() {
            if (this.buf == null) {
                ByteArrayBuffer baf = new ByteArrayBuffer();
                try {
                    baf.write(this.part.readOnce());
                }
                catch (IOException ioe) {
                    throw new WebServiceException((Throwable)ioe);
                }
                this.buf = baf.toByteArray();
            }
            return this.buf;
        }

        public DataHandler asDataHandler() {
            return this.buf != null ? new DataSourceStreamingDataHandler(new ByteArrayDataSource(this.buf, this.getContentType())) : new MIMEPartStreamingDataHandler(this.part);
        }

        public Source asSource() {
            return this.buf != null ? new StreamSource(new ByteArrayInputStream(this.buf)) : new StreamSource(this.part.read());
        }

        public InputStream asInputStream() {
            return this.buf != null ? new ByteArrayInputStream(this.buf) : this.part.read();
        }

        public void writeTo(OutputStream os) throws IOException {
            if (this.buf != null) {
                os.write(this.buf);
            } else {
                int len;
                InputStream in = this.part.read();
                byte[] temp = new byte[8192];
                while ((len = in.read(temp)) != -1) {
                    os.write(temp, 0, len);
                }
                in.close();
            }
        }

        public void writeTo(SOAPMessage saaj) throws SOAPException {
            saaj.createAttachmentPart().setDataHandler(this.asDataHandler());
        }
    }
}

