/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.buffer;

import com.sun.xml.stream.buffer.BaseBufferTestCase;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferMark;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferProcessor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class MarkTest
extends BaseBufferTestCase {
    private static final String SOAP_MESSAGE = "data/soap-message.xml";
    private static final String SOAP_NAMESPACE_URI = "http://www.w3.org/2003/05/soap-envelope";
    private static final String SOAP_ENVELOPE = "Envelope";
    private static final String SOAP_HEADER = "Header";
    private static final String SOAP_BODY = "Body";
    private URL _soapMessageURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("data/soap-message.xml");

    public MarkTest(String testName) {
        super(testName);
    }

    public void testMark() throws Exception {
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(this._soapMessageURL.openStream());
        this.nextElementContent(reader);
        this.verifyReaderState(reader, 1);
        MarkTest.verifyTag(reader, SOAP_NAMESPACE_URI, SOAP_ENVELOPE);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            namespaces.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
        }
        this.nextElementContent(reader);
        this.verifyReaderState(reader, 1);
        ArrayList<XMLStreamBufferMark> marks = new ArrayList<XMLStreamBufferMark>();
        StreamReaderBufferCreator creator = new StreamReaderBufferCreator(new MutableXMLStreamBuffer());
        if (reader.getLocalName() == SOAP_HEADER && reader.getNamespaceURI() == SOAP_NAMESPACE_URI) {
            for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                namespaces.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
            }
            this.nextElementContent(reader);
            if (reader.getEventType() == 1) {
                while (reader.getEventType() == 1) {
                    HashMap<String, String> headerBlockNamespaces = namespaces;
                    if (reader.getNamespaceCount() > 0) {
                        headerBlockNamespaces = new HashMap();
                        headerBlockNamespaces.putAll(namespaces);
                        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                            headerBlockNamespaces.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                        }
                    }
                    XMLStreamBufferMark mark = new XMLStreamBufferMark(headerBlockNamespaces, creator);
                    marks.add(mark);
                    creator.createElementFragment(reader, false);
                }
                this.nextElementContent(reader);
            }
        }
        MarkTest.verifyTag(reader, SOAP_NAMESPACE_URI, SOAP_BODY);
        TransformerHandler t = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
        t.setResult(new StreamResult(System.out));
        t.startDocument();
        t.startElement("", "root", "root", new AttributesImpl());
        for (XMLStreamBufferMark mark : marks) {
            StreamReaderBufferProcessor markReader = mark.readAsXMLStreamReader();
            this.processFragment((XMLStreamReader)((Object)markReader));
            mark.writeTo((ContentHandler)t, true);
        }
        t.endElement("", "root", "root");
        t.endDocument();
    }

    public void processFragment(XMLStreamReader reader) throws XMLStreamException {
        this.verifyReaderState(reader, 7);
        reader.next();
        this.verifyReaderState(reader, 1);
        int depth = 1;
        while (depth > 0) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
        reader.next();
        this.verifyReaderState(reader, 8);
        boolean exceptionThrown = false;
        try {
            reader.next();
        }
        catch (XMLStreamException e) {
            exceptionThrown = true;
        }
        MarkTest.assertEquals((boolean)true, (boolean)exceptionThrown);
    }
}

