/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serialize;

import com.sun.org.apache.xml.internal.serialize.ObjectFactory;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.Serializer;
import com.sun.org.apache.xml.internal.serialize.SerializerFactoryImpl;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.StringTokenizer;

public abstract class SerializerFactory {
    public static final String FactoriesProperty = "com.sun.org.apache.xml.internal.serialize.factories";
    private static Hashtable _factories = new Hashtable();
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$serialize$SerializerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSerializerFactory(SerializerFactory factory) {
        Hashtable hashtable = _factories;
        synchronized (hashtable) {
            String method = factory.getSupportedMethod();
            _factories.put(method, factory);
        }
    }

    public static SerializerFactory getSerializerFactory(String method) {
        return (SerializerFactory)_factories.get(method);
    }

    protected abstract String getSupportedMethod();

    public abstract Serializer makeSerializer(OutputFormat var1);

    public abstract Serializer makeSerializer(Writer var1, OutputFormat var2);

    public abstract Serializer makeSerializer(OutputStream var1, OutputFormat var2) throws UnsupportedEncodingException;

    static {
        SerializerFactory factory = new SerializerFactoryImpl("xml");
        SerializerFactory.registerSerializerFactory(factory);
        factory = new SerializerFactoryImpl("html");
        SerializerFactory.registerSerializerFactory(factory);
        factory = new SerializerFactoryImpl("xhtml");
        SerializerFactory.registerSerializerFactory(factory);
        factory = new SerializerFactoryImpl("text");
        SerializerFactory.registerSerializerFactory(factory);
        String list = System.getProperty(FactoriesProperty);
        if (list != null) {
            StringTokenizer token = new StringTokenizer(list, " ;,:");
            while (token.hasMoreTokens()) {
                String className = token.nextToken();
                try {
                    factory = (SerializerFactory)ObjectFactory.newInstance(className, (class$com$sun$org$apache$xml$internal$serialize$SerializerFactory == null ? SerializerFactory.class$("com.sun.org.apache.xml.internal.serialize.SerializerFactory") : class$com$sun$org$apache$xml$internal$serialize$SerializerFactory).getClassLoader(), true);
                    if (!_factories.containsKey(factory.getSupportedMethod())) continue;
                    _factories.put(factory.getSupportedMethod(), factory);
                }
                catch (Exception except) {}
            }
        }
    }
}

