/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MultiPartConfig {
    public static final String MULTI_PART_CONFIG_RESOURCE = "jersey-multipart-config.properties";
    public static final String BUFFER_THRESHOLD_NAME = "bufferThreshold";
    private int bufferThreshold = 4096;

    public MultiPartConfig() {
        this.configure();
    }

    public int getBufferThreshold() {
        return this.bufferThreshold;
    }

    private void configure() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        InputStream stream = null;
        try {
            stream = loader.getResourceAsStream(MULTI_PART_CONFIG_RESOURCE);
            if (stream == null) {
                return;
            }
            Properties props = new Properties();
            props.load(stream);
            String value = null;
            value = props.getProperty(BUFFER_THRESHOLD_NAME);
            if (value != null) {
                System.out.println("Setting bufferThreshold to " + value);
                this.bufferThreshold = Integer.valueOf(value);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

