/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.ComplexSelectorHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorHandlerPool;
import com.sun.grizzly.Context;
import com.sun.grizzly.ControllerConfig;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultConnectorHandlerPool;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.Handler;
import com.sun.grizzly.Lifecycle;
import com.sun.grizzly.NIOContext;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ReadController;
import com.sun.grizzly.RoundRobinSelectorHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.SelectorHandlerRunner;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.Cloner;
import com.sun.grizzly.util.ConcurrentLinkedQueuePool;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.DefaultThreadPool;
import com.sun.grizzly.util.FixedThreadPool;
import com.sun.grizzly.util.Grizzly;
import com.sun.grizzly.util.LinkedTransferQueue;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.State;
import com.sun.grizzly.util.StateHolder;
import com.sun.grizzly.util.SupportStateHolder;
import com.sun.grizzly.util.Utils;
import com.sun.grizzly.util.WorkerThreadFactory;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller
implements Runnable,
Lifecycle,
Copyable,
ConnectorHandlerPool,
AttributeHolder,
SupportStateHolder<State> {
    private int maxAcceptRetries = 5;
    private boolean displayConfiguration = false;
    private volatile int requiredThreadsCount = DefaultThreadPool.DEFAULT_MIN_THREAD_COUNT;
    private ConcurrentLinkedQueuePool<NIOContext> contexts;
    protected ProtocolChainInstanceHandler instanceHandler;
    protected SelectionKeyHandler selectionKeyHandler;
    protected ComplexSelectorHandler multiReadThreadSelectorHandler = null;
    protected ConnectorHandlerPool connectorHandlerPool = null;
    protected LinkedTransferQueue<SelectorHandler> selectorHandlers;
    protected StateHolder<State> stateHolder;
    protected int readThreadsCount = -1;
    protected ReadController[] readThreadControllers;
    protected static Logger logger = Logger.getLogger("grizzly");
    protected ExecutorService threadPool;
    protected final Collection<ControllerStateListener> stateListeners = new LinkedTransferQueue();
    protected AtomicInteger readySelectorHandlerCounter;
    protected AtomicInteger stoppedSelectorHandlerCounter;
    private boolean handleReadWriteConcurrently = true;
    protected Map<String, Object> attributes;
    private static final LinkedTransferQueue<Controller> controllers = new LinkedTransferQueue();
    private ExecutorService kernelExecutor;
    static final boolean isLinux = System.getProperty("os.name").equalsIgnoreCase("linux") && !System.getProperty("java.version").startsWith("1.7");
    private boolean allowContextCaching = false;
    private boolean useLeaderFollowerStrategy = false;
    private boolean autoConfigure = false;
    private boolean finishIOUsingCurrentThread = true;
    private int pendingIOlimitPerThread = 100;

    public Controller() {
        new ControllerConfig().configure(this);
        this.contexts = new ConcurrentLinkedQueuePool<NIOContext>(){

            public NIOContext newInstance() {
                return new NIOContext();
            }
        };
        this.stateHolder = new StateHolder(true);
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        if (this.instanceHandler == null) {
            this.instanceHandler = new DefaultProtocolChainInstanceHandler();
        }
        if (this.selectorHandlers == null) {
            this.selectorHandlers = new LinkedTransferQueue();
        }
        if (this.connectorHandlerPool == null) {
            this.connectorHandlerPool = new DefaultConnectorHandlerPool(this);
        }
        this.kernelExecutor = this.createKernelExecutor();
        controllers.add((Object)this);
    }

    private void ensureAppropriatePoolSize(ExecutorService threadPool) {
        ThreadPoolExecutor jdkThreadPool;
        if (threadPool == null) {
            return;
        }
        if (threadPool instanceof FixedThreadPool) {
            FixedThreadPool fixedThreadPool = (FixedThreadPool)threadPool;
            if (fixedThreadPool.getCorePoolSize() < this.requiredThreadsCount) {
                if (fixedThreadPool.getMaximumPoolSize() < this.requiredThreadsCount) {
                    fixedThreadPool.setMaximumPoolSize(this.requiredThreadsCount);
                }
                fixedThreadPool.setCorePoolSize(this.requiredThreadsCount);
            }
        } else if (threadPool instanceof ThreadPoolExecutor && (jdkThreadPool = (ThreadPoolExecutor)threadPool).getCorePoolSize() < this.requiredThreadsCount) {
            if (jdkThreadPool.getMaximumPoolSize() < this.requiredThreadsCount) {
                jdkThreadPool.setMaximumPoolSize(this.requiredThreadsCount);
            }
            jdkThreadPool.setCorePoolSize(this.requiredThreadsCount);
        }
    }

    private void autoConfigureCore() {
        if (this.autoConfigure && this.readThreadsCount == -1) {
            this.readThreadsCount = Runtime.getRuntime().availableProcessors();
            if (this.readThreadsCount > 0) {
                this.recalcRequiredThreadsCount();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Controller auto-configured with 2 ReadController based on underlying cores/processors, with a Thread Pool of required size " + this.requiredThreadsCount);
            }
        }
    }

    public void registerKey(SelectionKey key) {
        this.registerKey(key, 1);
    }

    public void registerKey(SelectionKey key, int ops) {
        this.registerKey(key, ops, ((SelectorHandler)this.selectorHandlers.peek()).protocol());
    }

    public void registerKey(SelectionKey key, int ops, Protocol protocol) {
        if (this.stateHolder.getState() == State.STOPPED) {
            return;
        }
        this.getSelectorHandler(protocol).register(key, ops);
    }

    public void cancelKey(SelectionKey key) {
        if (this.stateHolder.getState() == State.STOPPED) {
            return;
        }
        SelectorHandler selectorHandler = this.getSelectorHandler(key.selector());
        if (selectorHandler == null) {
            throw new IllegalStateException("SelectionKey is not associated with known SelectorHandler");
        }
        selectorHandler.getSelectionKeyHandler().cancel(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context pollContext() {
        NIOContext ctx = null;
        try {
            if (!this.allowContextCaching) {
                Thread thread = Thread.currentThread();
                if (thread instanceof WorkerThreadImpl) {
                    ctx = (NIOContext)((WorkerThreadImpl)thread).getContext();
                    if (ctx != null) {
                        ((WorkerThreadImpl)thread).setContext(null);
                    } else {
                        ctx = new NIOContext();
                    }
                } else {
                    ctx = new NIOContext();
                }
            } else {
                ctx = (NIOContext)this.contexts.poll();
            }
        }
        finally {
            ctx.setController(this);
        }
        return ctx;
    }

    public void configureContext(SelectionKey key, Context.OpType opType, NIOContext ctx, SelectorHandler selectorHandler) {
        ctx.setSelectorHandler(selectorHandler);
        ctx.setThreadPool(selectorHandler.getThreadPool());
        ctx.setAsyncQueueReader(selectorHandler.getAsyncQueueReader());
        ctx.setAsyncQueueWriter(selectorHandler.getAsyncQueueWriter());
        ctx.setSelectionKey(key);
        if (opType != null) {
            ctx.setCurrentOpType(opType);
        } else if (key != null) {
            ctx.configureOpType(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnContext(Context ctx) {
        if (ctx.decrementRefCount() > 0) {
            return;
        }
        if (!this.allowContextCaching) {
            WorkerThreadImpl wti;
            Thread thread = Thread.currentThread();
            if (thread instanceof WorkerThreadImpl && (wti = (WorkerThreadImpl)thread).getContext() == null) {
                ctx.recycle();
                wti.setContext((Object)ctx);
            }
            return;
        }
        try {
            ctx.recycle();
        }
        finally {
            this.contexts.offer((Object)((NIOContext)ctx));
        }
    }

    public static Logger logger() {
        return logger;
    }

    public static void setLogger(Logger l) {
        logger = l;
        LoggerUtils.setLogger((Logger)l);
    }

    public void setProtocolChainInstanceHandler(ProtocolChainInstanceHandler instanceHandler) {
        this.instanceHandler = instanceHandler;
    }

    public ProtocolChainInstanceHandler getProtocolChainInstanceHandler() {
        return this.instanceHandler;
    }

    public void setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.selectionKeyHandler = selectionKeyHandler;
    }

    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.selectionKeyHandler;
    }

    public void addSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandlers.add((Object)selectorHandler);
        if (this.stateHolder.getState(false) != null && !State.STOPPED.equals(this.stateHolder.getState())) {
            this.addSelectorHandlerOnReadControllers(selectorHandler);
            if (this.readySelectorHandlerCounter != null) {
                this.readySelectorHandlerCounter.incrementAndGet();
            }
            if (this.stoppedSelectorHandlerCounter != null) {
                this.stoppedSelectorHandlerCounter.incrementAndGet();
            }
            this.startSelectorHandlerRunner(selectorHandler);
        }
    }

    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.addSelectorHandler(selectorHandler);
    }

    public SelectorHandler getSelectorHandler(Protocol protocol) {
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            if (selectorHandler.protocol() != protocol) continue;
            return selectorHandler;
        }
        return null;
    }

    public SelectorHandler getSelectorHandler(Selector selector) {
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            if (selectorHandler.getSelector() != selector) continue;
            return selectorHandler;
        }
        return null;
    }

    public LinkedTransferQueue getSelectorHandlers() {
        return this.selectorHandlers;
    }

    public void removeSelectorHandler(SelectorHandler selectorHandler) {
        if (this.selectorHandlers.remove((Object)selectorHandler)) {
            this.removeSelectorHandlerOnReadControllers(selectorHandler);
            selectorHandler.shutdown();
        }
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.ensureAppropriatePoolSize(threadPool);
        this.threadPool = threadPool;
    }

    public int getReadThreadsCount() {
        return this.readThreadsCount;
    }

    public void setReadThreadsCount(int readThreadsCount) {
        this.readThreadsCount = readThreadsCount;
        if (readThreadsCount > 0) {
            this.recalcRequiredThreadsCount();
        }
        this.ensureAppropriatePoolSize(this.threadPool);
    }

    public ConnectorHandlerPool getConnectorHandlerPool() {
        return this.connectorHandlerPool;
    }

    public void setConnectorHandlerPool(ConnectorHandlerPool connectorHandlerPool) {
        this.connectorHandlerPool = connectorHandlerPool;
    }

    @Override
    public void run() {
        try {
            this.start();
        }
        catch (IOException e) {
            this.notifyException(e);
            throw new RuntimeException(e.getCause());
        }
    }

    public void copyTo(Copyable copy) {
        Controller copyController = (Controller)copy;
        copyController.contexts = this.contexts;
        copyController.attributes = this.attributes;
        copyController.instanceHandler = this.instanceHandler;
        copyController.threadPool = this.threadPool;
        copyController.readThreadControllers = this.readThreadControllers;
        copyController.readThreadsCount = this.readThreadsCount;
        copyController.selectionKeyHandler = this.selectionKeyHandler;
        copyController.stateHolder = this.stateHolder;
        copyController.finishIOUsingCurrentThread = this.finishIOUsingCurrentThread;
        copyController.pendingIOlimitPerThread = this.pendingIOlimitPerThread;
    }

    public void addStateListener(ControllerStateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    public void removeStateListener(ControllerStateListener stateListener) {
        this.stateListeners.remove(stateListener);
    }

    public void notifyStarted() {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onStarted();
        }
    }

    public void notifyReady() {
        if (this.readySelectorHandlerCounter.decrementAndGet() == 0) {
            for (ControllerStateListener stateListener : this.stateListeners) {
                stateListener.onReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStopped() {
        if (this.stoppedSelectorHandlerCounter.decrementAndGet() == 0) {
            AtomicInteger atomicInteger = this.stoppedSelectorHandlerCounter;
            synchronized (atomicInteger) {
                this.stoppedSelectorHandlerCounter.notifyAll();
            }
        }
    }

    protected void notifyException(Throwable e) {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onException(e);
        }
    }

    public void logVersion() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Starting Grizzly Framework " + Grizzly.getRawVersion() + " - " + new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        if (this.isStarted()) {
            return;
        }
        this.logVersion();
        this.stateHolder.getStateLocker().writeLock().lock();
        boolean isUnlocked = false;
        if (this.kernelExecutor.isShutdown()) {
            this.kernelExecutor = this.createKernelExecutor();
        }
        this.autoConfigureCore();
        if (this.threadPool == null) {
            this.threadPool = new DefaultThreadPool();
        }
        if (this.threadPool.isShutdown()) {
            this.threadPool = new DefaultThreadPool();
        }
        this.ensureAppropriatePoolSize(this.threadPool);
        try {
            if (this.stateHolder.getState(false) == null || this.stateHolder.getState(false) == State.STOPPED) {
                if (this.selectorHandlers.isEmpty()) {
                    TCPSelectorHandler selectorHandler = new TCPSelectorHandler();
                    this.selectorHandlers.add((Object)selectorHandler);
                }
                if (this.readThreadsCount > 0) {
                    this.initReadThreads();
                    this.multiReadThreadSelectorHandler = new RoundRobinSelectorHandler(this.readThreadControllers);
                }
                this.stateHolder.setState((Object)State.STARTED, false);
                this.notifyStarted();
                int selectorHandlerCount = this.selectorHandlers.size();
                this.readySelectorHandlerCounter = new AtomicInteger(selectorHandlerCount);
                this.stoppedSelectorHandlerCounter = new AtomicInteger(selectorHandlerCount);
                Iterator it = this.selectorHandlers.iterator();
                while (it.hasNext() && selectorHandlerCount-- > 0) {
                    SelectorHandler selectorHandler = (SelectorHandler)it.next();
                    if (selectorHandler instanceof TCPSelectorHandler) {
                        ((TCPSelectorHandler)selectorHandler).setFinishIOUsingCurrentThread(this.finishIOUsingCurrentThread);
                        ((TCPSelectorHandler)selectorHandler).setPendingIOlimitPerThread(this.pendingIOlimitPerThread);
                        ((TCPSelectorHandler)selectorHandler).setMaxAcceptRetries(this.maxAcceptRetries);
                    }
                    this.startSelectorHandlerRunner(selectorHandler);
                }
            }
        }
        finally {
            if (!isUnlocked) {
                this.stateHolder.getStateLocker().writeLock().unlock();
            }
        }
        if (this.displayConfiguration) {
            this.displayConfiguration();
        }
        this.waitUntilSeletorHandlersStop();
        if (this.readThreadsCount > 0) {
            this.multiReadThreadSelectorHandler.shutdown();
            this.multiReadThreadSelectorHandler = null;
            for (ReadController readController : this.readThreadControllers) {
                try {
                    ((Controller)readController).stop();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Exception occured when stopping read Controller!", e);
                }
            }
            this.readThreadControllers = null;
        }
        this.selectorHandlers.clear();
        this.threadPool.shutdown();
        this.attributes = null;
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onStopped();
        }
    }

    @Override
    public void stop() throws IOException {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean isAsync) throws IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.stateHolder.getStateLocker().writeLock().lock();
        try {
            if (this.stateHolder.getState(false) == State.STOPPED) {
                logger.log(Level.FINE, "Controller is already in stopped state");
                return;
            }
            if (!isAsync) {
                this.addStateListener(new ControllerStateListenerAdapter(){

                    public void onException(Throwable e) {
                        Controller.this.removeStateListener(this);
                        latch.countDown();
                    }

                    public void onStopped() {
                        Controller.this.removeStateListener(this);
                        latch.countDown();
                    }
                });
            }
            this.stateHolder.setState((Object)State.STOPPED, false);
        }
        finally {
            this.stateHolder.getStateLocker().writeLock().unlock();
        }
        if (!isAsync) {
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.kernelExecutor.shutdownNow();
    }

    @Override
    public void pause() throws IOException {
        this.stateHolder.setState((Object)State.PAUSED);
    }

    @Override
    public void resume() throws IOException {
        if (!State.PAUSED.equals(this.stateHolder.getState(false))) {
            throw new IllegalStateException("Controller is not in PAUSED state, but: " + this.stateHolder.getState(false));
        }
        this.stateHolder.setState((Object)State.STARTED);
    }

    public StateHolder<State> getStateHolder() {
        return this.stateHolder;
    }

    private void initReadThreads() throws IOException {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(2);
        }
        this.readThreadControllers = new ReadController[this.readThreadsCount];
        for (int i = 0; i < this.readThreadsCount; ++i) {
            ReadController controller = new ReadController();
            this.copyTo(controller);
            controller.setReadThreadsCount(0);
            this.readThreadControllers[i] = controller;
        }
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            this.addSelectorHandlerOnReadControllers(selectorHandler);
        }
        for (int i = 0; i < this.readThreadControllers.length; ++i) {
            this.kernelExecutor.execute(this.readThreadControllers[i]);
        }
    }

    private void addSelectorHandlerOnReadControllers(SelectorHandler selectorHandler) {
        if (this.readThreadControllers == null || this.readThreadsCount == 0) {
            return;
        }
        if (selectorHandler.getAttributes() == null) {
            selectorHandler.setAttributes(new HashMap(2));
        }
        for (ReadController readController : this.readThreadControllers) {
            SelectorHandler copySelectorHandler = (SelectorHandler)Cloner.clone((Copyable)selectorHandler);
            try {
                copySelectorHandler.setSelector(Utils.openSelector());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error opening selector!", e);
            }
            readController.addSelectorHandler(copySelectorHandler);
        }
    }

    protected void startSelectorHandlerRunner(SelectorHandler selectorHandler) {
        if (selectorHandler.getThreadPool() == null) {
            selectorHandler.setThreadPool(this.threadPool);
        }
        SelectorHandlerRunner selectorRunner = new SelectorHandlerRunner(this, selectorHandler);
        if (selectorHandler.getSelector() != null) {
            this.notifyReady();
        }
        if (this.useLeaderFollowerStrategy) {
            this.threadPool.execute(selectorRunner);
        } else {
            this.kernelExecutor.execute(selectorRunner);
        }
    }

    private void removeSelectorHandlerOnReadControllers(SelectorHandler selectorHandler) {
        if (this.readThreadControllers == null) {
            return;
        }
        for (ReadController readController : this.readThreadControllers) {
            readController.removeSelectorHandlerClone(selectorHandler);
        }
    }

    public boolean isStarted() {
        return this.stateHolder.getState() == State.STARTED;
    }

    public ConnectorHandler acquireConnectorHandler(Protocol protocol) {
        return this.connectorHandlerPool.acquireConnectorHandler(protocol);
    }

    public void releaseConnectorHandler(ConnectorHandler connectorHandler) {
        this.connectorHandlerPool.releaseConnectorHandler(connectorHandler);
    }

    public boolean isHandleReadWriteConcurrently() {
        return this.handleReadWriteConcurrently;
    }

    public void setHandleReadWriteConcurrently(boolean handleReadWriteConcurrently) {
        this.handleReadWriteConcurrently = handleReadWriteConcurrently;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilSeletorHandlersStop() {
        AtomicInteger atomicInteger = this.stoppedSelectorHandlerCounter;
        synchronized (atomicInteger) {
            while (this.stoppedSelectorHandlerCounter.get() > 0 || !State.STOPPED.equals(this.stateHolder.getState())) {
                try {
                    this.stoppedSelectorHandlerCounter.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public Object removeAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(key);
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static Controller getHandlerController(Handler handler) {
        if (handler instanceof SelectorHandler) {
            for (Controller controller : controllers) {
                if (!controller.getSelectorHandlers().contains((Object)handler)) continue;
                return controller;
            }
        }
        return null;
    }

    protected void executeUsingKernelExecutor() {
        this.kernelExecutor.submit(this);
    }

    public void executeUsingKernelExecutor(Runnable r) {
        this.kernelExecutor.execute(r);
    }

    protected ExecutorService createKernelExecutor() {
        return Executors.newCachedThreadPool((ThreadFactory)new WorkerThreadFactory("grizzly-kernel"));
    }

    public boolean isAllowContextCaching() {
        return this.allowContextCaching;
    }

    public void setAllowContextCaching(boolean allowContextCaching) {
        this.allowContextCaching = allowContextCaching;
    }

    public boolean useLeaderFollowerStrategy() {
        return this.useLeaderFollowerStrategy;
    }

    public void useLeaderFollowerStrategy(boolean useLeaderFollowerStrategy) {
        this.useLeaderFollowerStrategy = useLeaderFollowerStrategy;
    }

    public boolean isAutoConfigure() {
        return this.autoConfigure;
    }

    public void setAutoConfigure(boolean autoConfigure) {
        this.autoConfigure = autoConfigure;
    }

    private void recalcRequiredThreadsCount() {
        int selectorHandlersCount = this.selectorHandlers.size();
        int clonesNumber = selectorHandlersCount > 0 ? selectorHandlersCount : 1;
        this.requiredThreadsCount = clonesNumber * (this.readThreadsCount + 1) * 2;
    }

    public boolean isFinishIOUsingCurrentThread() {
        return this.finishIOUsingCurrentThread;
    }

    public void setFinishIOUsingCurrentThread(boolean finishIOUsingCurrentThread) {
        this.finishIOUsingCurrentThread = finishIOUsingCurrentThread;
    }

    public int getPendingIOlimitPerThread() {
        return this.pendingIOlimitPerThread;
    }

    public void setPendingIOlimitPerThread(int pendingIOlimitPerThread) {
        this.pendingIOlimitPerThread = pendingIOlimitPerThread;
    }

    public void setMaxAcceptRetries(int maxAcceptRetries) {
        this.maxAcceptRetries = maxAcceptRetries;
    }

    public void setDisplayConfiguration(boolean displayConfiguration) {
        this.displayConfiguration = displayConfiguration;
    }

    private void displayConfiguration() {
        if (this.displayConfiguration) {
            logger.log(Level.INFO, "\n Grizzly running on " + System.getProperty("os.name") + "-" + System.getProperty("os.version") + " under JDK version: " + System.getProperty("java.version") + "-" + System.getProperty("java.vendor") + "\n\t Thread Pool: " + this.threadPool + "\n\t Read Selector: " + this.readThreadsCount + "\n\t auto-configure: " + this.autoConfigure + "\n\t Using Leader/follower strategy: " + this.useLeaderFollowerStrategy + "\n\t Number of SelectorHandler: " + this.selectorHandlers.size() + "\n\t SelectionKeyHandler: " + this.selectionKeyHandler + "\n\t Context Caching: " + this.isAllowContextCaching() + "\n\t Maximum Accept Retry: " + this.maxAcceptRetries + "\n\t Handler Read/Write I/O Concurrently " + this.handleReadWriteConcurrently + "\n\t ProtocolChainHandler: " + this.getProtocolChainInstanceHandler());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        UDP,
        TCP,
        TLS,
        CUSTOM;

    }
}

