/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.standalonemojos;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.services.androidpublisher.AndroidPublisher;
import com.google.api.services.androidpublisher.model.Listing;
import com.simpligility.maven.plugins.android.AbstractPublisherMojo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="publish-listing", requiresProject=false)
public class PublishListingMojo
extends AbstractPublisherMojo {
    private static final int MAX_CHARS_TITLE = 30;
    private static final int MAX_CHARS_SHORT_DESCRIPTION = 80;
    private static final int MAX_CHARS_FULL_DESCRIPTION = 4000;
    private static final int MAX_SCREENSHOTS_SIZE = 8;
    private static final String LISTING_PATH = "listing/";
    private static final String IMAGE_TYPE_FEATURE_GRAPHIC = "featureGraphic";
    private static final String IMAGE_TYPE_ICON = "icon";
    private static final String IMAGE_TYPE_PHONE_SCREENSHOTS = "phoneScreenshots";
    private static final String IMAGE_TYPE_PROMO_GRAPHIC = "promoGraphic";
    private static final String IMAGE_TYPE_SEVEN_INCH_SCREENSHOTS = "sevenInchScreenshots";
    private static final String IMAGE_TYPE_TEN_INCH_SCREENSHOTS = "tenInchScreenshots";
    private static final String IMAGE_TYPE_TV_BANNER = "tvBanner";
    private static final String IMAGE_TYPE_TV_SCREENSHOTS = "tvScreenshots";
    @Parameter(property="android.publisher.package.name")
    private String packageName;
    @Parameter(property="android.publisher.filename.full.description", defaultValue="fulldescription.txt")
    private String fileNameFullDescription;
    @Parameter(property="android.publisher.filename.short.description", defaultValue="shortdescription.txt")
    private String fileNameShortDescription;
    @Parameter(property="android.publisher.filename.title", defaultValue="title.txt")
    private String fileNameTitle;
    @Parameter(property="android.publisher.upload.images", defaultValue="false")
    private boolean uploadImages;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.packageName == null || this.packageName.equals("")) {
            this.packageName = this.extractPackageNameFromAndroidManifest(this.androidManifestFile);
        }
        this.getLog().debug((CharSequence)("Package name: " + this.packageName));
        this.initializePublisher(this.packageName);
        this.publishListing();
    }

    private void publishListing() throws MojoExecutionException, MojoFailureException {
        this.warnPlatformDefaultEncoding();
        File[] localeDirs = this.getLocaleDirs();
        if (localeDirs == null) {
            return;
        }
        try {
            for (File localeDir : localeDirs) {
                File listingDir = new File(localeDir, LISTING_PATH);
                if (listingDir.exists()) {
                    String fullDescription = this.readFileWithChecks(listingDir, this.fileNameFullDescription, 4000, "Full description file is missing.");
                    String shortDescription = this.readFileWithChecks(listingDir, this.fileNameShortDescription, 80, "Short description file is missing.");
                    String title = this.readFileWithChecks(listingDir, this.fileNameTitle, 30, "Title file is missing.");
                    if (title == null || shortDescription == null || fullDescription == null) {
                        throw new MojoFailureException("Incomplete listing");
                    }
                    this.getLog().info((CharSequence)("Updating the listing for " + this.packageName));
                    Listing listing = new Listing();
                    listing.setTitle(title);
                    listing.setFullDescription(fullDescription);
                    listing.setShortDescription(shortDescription);
                    this.edits.listings().update(this.packageName, this.editId, localeDir.getName(), listing).execute();
                    if (this.uploadImages) {
                        this.uploadSingleGraphic(listingDir, localeDir.getName(), IMAGE_TYPE_FEATURE_GRAPHIC);
                        this.uploadSingleGraphic(listingDir, localeDir.getName(), IMAGE_TYPE_ICON);
                        this.uploadSingleGraphic(listingDir, localeDir.getName(), IMAGE_TYPE_PROMO_GRAPHIC);
                        this.uploadScreenShots(listingDir, localeDir.getName(), IMAGE_TYPE_PHONE_SCREENSHOTS);
                        this.uploadScreenShots(listingDir, localeDir.getName(), IMAGE_TYPE_SEVEN_INCH_SCREENSHOTS);
                        this.uploadScreenShots(listingDir, localeDir.getName(), IMAGE_TYPE_TEN_INCH_SCREENSHOTS);
                        this.uploadSingleGraphic(listingDir, localeDir.getName(), IMAGE_TYPE_TV_BANNER);
                        this.uploadScreenShots(listingDir, localeDir.getName(), IMAGE_TYPE_TV_SCREENSHOTS);
                    }
                    this.edits.commit(this.packageName, this.editId).execute();
                    continue;
                }
                this.getLog().warn((CharSequence)"Listing directory is missing.");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Problem in the listing content: " + e.getMessage(), (Exception)e);
        }
    }

    private List<AbstractInputStreamContent> getImageListAsStream(File listingDir, String graphicPath) {
        File graphicDir = new File(listingDir, graphicPath);
        ArrayList<AbstractInputStreamContent> images = new ArrayList<AbstractInputStreamContent>();
        if (graphicDir.exists()) {
            File[] imageFiles;
            for (File imageFile : imageFiles = graphicDir.listFiles()) {
                images.add((AbstractInputStreamContent)new FileContent("image/*", imageFile));
            }
        }
        return images;
    }

    private AbstractInputStreamContent getImageAsStream(File listingDir, String graphicPath) throws MojoFailureException {
        File graphicDir = new File(listingDir, graphicPath);
        if (graphicDir.exists()) {
            File[] files = graphicDir.listFiles();
            if (files == null || files.length == 0) {
                this.getLog().warn((CharSequence)("There are no images in " + graphicDir.getAbsolutePath()));
            } else {
                if (files.length > 1) {
                    throw new MojoFailureException("There should be exactly 1 image in " + graphicDir.getAbsolutePath());
                }
                File graphicFile = files[0];
                return new FileContent("image/*", graphicFile);
            }
        }
        return null;
    }

    private void uploadSingleGraphic(File dir, String locale, String imageType) throws MojoExecutionException, MojoFailureException {
        AbstractInputStreamContent contentGraphic = this.getImageAsStream(dir, imageType);
        if (contentGraphic == null) {
            return;
        }
        AndroidPublisher.Edits.Images images = this.edits.images();
        try {
            this.getLog().info((CharSequence)("Deleting the old " + imageType));
            images.deleteall(this.packageName, this.editId, locale, imageType).execute();
            this.getLog().info((CharSequence)("Uploading the " + imageType));
            images.upload(this.packageName, this.editId, locale, imageType, contentGraphic).execute();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void uploadScreenShots(File dir, String locale, String imageType) throws MojoFailureException, MojoExecutionException {
        List<AbstractInputStreamContent> contentGraphicList = this.getImageListAsStream(dir, imageType);
        if (contentGraphicList == null || contentGraphicList.isEmpty()) {
            this.getLog().warn((CharSequence)("There are no images in " + dir.getAbsolutePath() + "/" + imageType));
            return;
        }
        AndroidPublisher.Edits.Images images = this.edits.images();
        try {
            this.getLog().info((CharSequence)("Deleting the old " + imageType));
            images.deleteall(this.packageName, this.editId, locale, imageType).execute();
            if (contentGraphicList.size() > 8) {
                String message = "You can only upload 8 screen shots";
                this.getLog().error((CharSequence)message);
                throw new MojoFailureException(message);
            }
            int i = 1;
            for (AbstractInputStreamContent contentGraphic : contentGraphicList) {
                this.getLog().info((CharSequence)("Uploading " + imageType + " " + i + " out of " + contentGraphicList.size()));
                images.upload(this.packageName, this.editId, locale, imageType, contentGraphic).execute();
                ++i;
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

