/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.standalonemojos;

import com.android.annotations.NonNull;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.services.androidpublisher.AndroidPublisher;
import com.google.api.services.androidpublisher.model.Apk;
import com.google.api.services.androidpublisher.model.ApkListing;
import com.google.api.services.androidpublisher.model.Track;
import com.simpligility.maven.plugins.android.AbstractPublisherMojo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="publish-apk", requiresProject=false)
public class PublishApkMojo
extends AbstractPublisherMojo {
    private static final int MAX_CHARS_WHATSNEW = 500;
    @Parameter(property="android.publisher.track", defaultValue="alpha")
    private String track;
    @Parameter(property="android.publisher.apkpath")
    private File apkFile;
    @Parameter(property="android.publisher.filename.whatsnew", defaultValue="whatsnew.txt")
    private String fileNameWhatsnew;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.apkFile == null) {
            this.apkFile = new File(this.targetDirectory, this.finalName + "-aligned." + "apk");
        }
        String packageName = this.extractPackageNameFromApk(this.apkFile);
        this.getLog().debug((CharSequence)("Package name: " + packageName));
        this.initializePublisher(packageName);
        this.publishApk(packageName);
    }

    private void publishApk(@NonNull String packageName) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Starting upload of apk " + this.apkFile.getAbsolutePath()));
            FileContent newApkFile = new FileContent("application/vnd.android.package-archive", this.apkFile);
            Apk apk = (Apk)this.edits.apks().upload(packageName, this.editId, (AbstractInputStreamContent)newApkFile).execute();
            ArrayList<Integer> versionCodes = new ArrayList<Integer>();
            versionCodes.add(apk.getVersionCode());
            Track newTrack = new Track().setVersionCodes(versionCodes);
            this.edits.tracks().update(packageName, this.editId, this.track, newTrack).execute();
            this.publishWhatsNew(packageName, this.edits, this.editId, apk);
            this.edits.commit(packageName, this.editId).execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void publishWhatsNew(String packageName, AndroidPublisher.Edits edits, String editId, Apk apk) throws IOException {
        this.warnPlatformDefaultEncoding();
        File[] localeDirs = this.getLocaleDirs();
        if (localeDirs == null) {
            return;
        }
        for (File localeDir : localeDirs) {
            String recentChanges = this.readFileWithChecks(localeDir, this.fileNameWhatsnew, 500, "What's new texts are missing.");
            if (recentChanges == null) continue;
            ApkListing newApkListing = new ApkListing().setRecentChanges(recentChanges);
            edits.apklistings().update(packageName, editId, apk.getVersionCode(), localeDir.getName(), newApkListing).execute();
        }
    }
}

