/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.standalonemojos;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.simpligility.maven.plugins.android.AbstractAndroidMojo;
import com.simpligility.maven.plugins.android.AndroidTestRunListener;
import com.simpligility.maven.plugins.android.CommandExecutor;
import com.simpligility.maven.plugins.android.DeviceCallback;
import com.simpligility.maven.plugins.android.ExecutionException;
import com.simpligility.maven.plugins.android.config.ConfigHandler;
import com.simpligility.maven.plugins.android.config.ConfigPojo;
import com.simpligility.maven.plugins.android.config.PullParameter;
import com.simpligility.maven.plugins.android.configuration.MonkeyRunner;
import com.simpligility.maven.plugins.android.configuration.Program;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.interpolation.os.Os;
import org.codehaus.plexus.util.cli.shell.BourneShell;
import org.codehaus.plexus.util.cli.shell.Shell;

@Mojo(name="monkeyrunner")
public class MonkeyRunnerMojo
extends AbstractAndroidMojo {
    @Parameter(property="maven.test.skip", defaultValue="false", readonly=true)
    private boolean mavenTestSkip;
    @Parameter(property="skipTests", defaultValue="false", readonly=true)
    private boolean mavenSkipTests;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false", readonly=true)
    private boolean mavenTestFailureIgnore;
    @Parameter(property="testFailureIgnore", defaultValue="false", readonly=true)
    private boolean mavenIgnoreTestFailure;
    @ConfigPojo
    @Parameter
    private MonkeyRunner monkeyrunner;
    @Parameter(property="android.monkeyrunner.skip")
    private Boolean monkeyRunnerSkip;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedSkip;
    @Parameter(property="android.monkeyrunner.plugins")
    private String[] monkeyPlugins;
    @PullParameter(defaultValueGetterMethod="getPlugins")
    private String[] parsedPlugins;
    @PullParameter(required=false, defaultValueGetterMethod="getPrograms")
    @Parameter
    private List<Program> parsedPrograms;
    @Parameter(property="android.monkeyrunner.createReport")
    private Boolean monkeyCreateReport;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedCreateReport;
    @Parameter(property="android.monkeyrunner.injectDeviceSerialNumberIntoScript")
    private Boolean monkeyInjectDeviceSerialNumberIntoScript;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedInjectDeviceSerialNumberIntoScript;
    private long elapsedTime;
    private ITestRunListener[] mTestListeners;
    private Map<String, String> runMetrics;
    private String mRunName;
    private int eventCount;
    private TestIdentifier mCurrentTestIndentifier;
    private MonkeyRunnerErrorListener errorListener;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ConfigHandler configHandler = new ConfigHandler((Object)this, this.session, this.execution);
        configHandler.parseConfiguration();
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException, MojoFailureException {
                AndroidTestRunListener testRunListener = new AndroidTestRunListener(MonkeyRunnerMojo.this.project, device, MonkeyRunnerMojo.this.getLog(), MonkeyRunnerMojo.this.parsedCreateReport, false, "", "", MonkeyRunnerMojo.this.targetDirectory);
                if (MonkeyRunnerMojo.this.isEnableIntegrationTest()) {
                    MonkeyRunnerMojo.this.run(device, testRunListener);
                }
            }
        });
    }

    protected boolean isEnableIntegrationTest() {
        return this.parsedSkip == false && !this.mavenTestSkip && !this.mavenSkipTests;
    }

    protected boolean isIgnoreTestFailures() {
        return this.mavenIgnoreTestFailure || this.mavenTestFailureIgnore;
    }

    protected void run(IDevice device, ITestRunListener ... iTestRunListeners) throws MojoExecutionException, MojoFailureException {
        this.mTestListeners = iTestRunListeners;
        this.getLog().debug((CharSequence)"Parsed values for Android Monkey Runner invocation: ");
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        if (!Os.isFamily((String)"windows")) {
            executor.setCustomShell((Shell)new CustomBourneShell());
        }
        executor.setLogger(this.getLog());
        String command = this.getAndroidSdk().getMonkeyRunnerPath();
        ArrayList<String> pluginParameters = new ArrayList<String>();
        if (this.parsedPlugins != null && this.parsedPlugins.length != 0) {
            for (String plugin : this.parsedPlugins) {
                String pluginFilePath = new File(this.project.getBasedir(), plugin).getAbsolutePath();
                pluginParameters.add("-plugin " + pluginFilePath);
            }
        }
        if (this.parsedPrograms != null && !this.parsedPrograms.isEmpty()) {
            this.handleTestRunStarted();
            this.errorListener = new MonkeyRunnerErrorListener();
            executor.setErrorListener(this.errorListener);
            for (Program program : this.parsedPrograms) {
                block11: {
                    ArrayList<String> parameters = new ArrayList<String>(pluginParameters);
                    String programFileName = new File(this.project.getBasedir(), program.getFilename()).getAbsolutePath();
                    parameters.add(programFileName);
                    String testName = programFileName;
                    if (testName.contains("/")) {
                        testName.substring(testName.indexOf(47) + 1);
                    }
                    this.mCurrentTestIndentifier = new TestIdentifier("MonkeyTest ", testName);
                    String programOptions = program.getOptions();
                    if (this.parsedInjectDeviceSerialNumberIntoScript != null && this.parsedInjectDeviceSerialNumberIntoScript.booleanValue()) {
                        parameters.add(device.getSerialNumber());
                    }
                    if (programOptions != null && !StringUtils.isEmpty((String)programOptions)) {
                        parameters.add(programOptions);
                    }
                    try {
                        this.getLog().info((CharSequence)("Running command: " + command));
                        this.getLog().info((CharSequence)("with parameters: " + parameters));
                        this.handleTestStarted();
                        executor.setCaptureStdOut(true);
                        executor.executeCommand(command, parameters, true);
                        this.handleTestEnded();
                    }
                    catch (ExecutionException e) {
                        this.getLog().info((CharSequence)"Monkey runner produced errors");
                        this.handleTestRunFailed(e.getMessage());
                        if (this.isIgnoreTestFailures()) break block11;
                        this.getLog().info((CharSequence)"Project is configured to fail on error.");
                        this.getLog().info((CharSequence)"Inspect monkey runner reports or re-run with -X to see monkey runner errors in log");
                        this.getLog().info((CharSequence)"Failing build as configured. Ignore following error message.");
                        if (this.errorListener.hasError) {
                            this.getLog().info((CharSequence)"Stack trace is:");
                            this.getLog().info((CharSequence)this.errorListener.getStackTrace());
                        }
                        throw new MojoExecutionException("", (Exception)e);
                    }
                }
                if (!this.errorListener.hasError()) continue;
                this.handleCrash();
            }
            this.handleTestRunEnded();
        }
        this.getLog().info((CharSequence)"Monkey runner test runs completed successfully.");
    }

    private void handleTestRunStarted() {
        this.runMetrics = new HashMap<String, String>();
        this.elapsedTime = System.currentTimeMillis();
        for (ITestRunListener listener : this.mTestListeners) {
            listener.testRunStarted(this.mRunName, this.eventCount);
        }
    }

    private void handleTestRunFailed(String error) {
        for (ITestRunListener listener : this.mTestListeners) {
            listener.testRunFailed(error);
        }
    }

    private void handleTestRunEnded() {
        this.elapsedTime = System.currentTimeMillis() - this.elapsedTime;
        for (ITestRunListener listener : this.mTestListeners) {
            listener.testRunEnded(this.elapsedTime, this.runMetrics);
        }
    }

    private void handleTestStarted() {
        System.out.println("TEST START " + this.mTestListeners.length);
        for (ITestRunListener listener : this.mTestListeners) {
            listener.testStarted(this.mCurrentTestIndentifier);
        }
    }

    private void handleTestEnded() {
        if (this.mCurrentTestIndentifier != null) {
            for (ITestRunListener listener : this.mTestListeners) {
                listener.testEnded(this.mCurrentTestIndentifier, new HashMap());
            }
            this.mCurrentTestIndentifier = null;
        }
    }

    private void handleCrash() {
        String trace = this.errorListener.getStackTrace();
        for (ITestRunListener listener : this.mTestListeners) {
            listener.testFailed(this.mCurrentTestIndentifier, trace);
        }
        this.mCurrentTestIndentifier = null;
    }

    public String[] getPlugins() {
        return this.parsedPlugins;
    }

    public List<Program> getPrograms() {
        return this.parsedPrograms;
    }

    private static final class CustomBourneShell
    extends BourneShell {
        private CustomBourneShell() {
        }

        public List<String> getShellArgsList() {
            ArrayList<String> shellArgs = new ArrayList<String>();
            List existingShellArgs = super.getShellArgsList();
            if (existingShellArgs != null && !existingShellArgs.isEmpty()) {
                shellArgs.addAll(existingShellArgs);
            }
            return shellArgs;
        }

        public String[] getShellArgs() {
            String[] shellArgs = super.getShellArgs();
            if (shellArgs == null) {
                shellArgs = new String[]{};
            }
            return shellArgs;
        }
    }

    private final class MonkeyRunnerErrorListener
    implements CommandExecutor.ErrorListener {
        private StringBuilder stackTraceBuilder = new StringBuilder();
        private boolean hasError = false;

        private MonkeyRunnerErrorListener() {
        }

        @Override
        public boolean isError(String error) {
            Pattern pattern;
            Matcher matcher;
            if (MonkeyRunnerMojo.this.isIgnoreTestFailures()) {
                return false;
            }
            if (this.hasError) {
                this.stackTraceBuilder.append(error).append('\n');
            }
            if ((matcher = (pattern = Pattern.compile(".*error.*|.*exception.*", 2)).matcher(error)).matches()) {
                this.hasError = true;
                this.stackTraceBuilder.append(error).append('\n');
                return true;
            }
            return false;
        }

        public String getStackTrace() {
            if (this.hasError) {
                return this.stackTraceBuilder.toString();
            }
            return null;
        }

        public boolean hasError() {
            return this.hasError;
        }
    }
}

