/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.phase09package;

import com.android.sdklib.build.ApkBuilder;
import com.android.sdklib.build.ApkCreationException;
import com.android.sdklib.build.DuplicateFileException;
import com.android.sdklib.build.SealedApkException;
import com.simpligility.maven.plugins.android.AbstractAndroidMojo;
import com.simpligility.maven.plugins.android.AndroidNdk;
import com.simpligility.maven.plugins.android.AndroidSigner;
import com.simpligility.maven.plugins.android.CommandExecutor;
import com.simpligility.maven.plugins.android.ExecutionException;
import com.simpligility.maven.plugins.android.common.AaptCommandBuilder;
import com.simpligility.maven.plugins.android.common.NativeHelper;
import com.simpligility.maven.plugins.android.config.ConfigHandler;
import com.simpligility.maven.plugins.android.config.ConfigPojo;
import com.simpligility.maven.plugins.android.config.PullParameter;
import com.simpligility.maven.plugins.android.configuration.Apk;
import com.simpligility.maven.plugins.android.configuration.MetaInf;
import com.simpligility.maven.plugins.android.configuration.Sign;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;

@Mojo(name="apk", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ApkMojo
extends AbstractAndroidMojo {
    @Parameter
    private Sign sign;
    @Parameter(property="android.sign.debug", defaultValue="auto", readonly=true)
    private String signDebug;
    @Parameter(property="android.renameInstrumentationTargetPackage")
    private String renameInstrumentationTargetPackage;
    @Parameter(property="android.extractDuplicates", defaultValue="false")
    private boolean extractDuplicates;
    @Parameter
    private String classifier;
    @Parameter(property="android.outputApk", defaultValue="${project.build.directory}/${project.build.finalName}.apk")
    private String outputApk;
    @Parameter(property="android.sourceDirectories")
    private File[] sourceDirectories;
    @PullParameter
    private String[] apkMetaIncludes;
    @PullParameter(defaultValueGetterMethod="getDefaultMetaInf")
    private MetaInf apkMetaInf;
    @Parameter(alias="metaInf")
    private MetaInf pluginMetaInf;
    @PullParameter(defaultValue={"false"})
    @Parameter(property="android.apk.debug")
    private Boolean apkDebug;
    @PullParameter(defaultValue={"arm-linux-androideabi-4.4.3"})
    @Parameter(property="android.nativeToolchain")
    private String apkNativeToolchain;
    @Parameter(property="android.ndk.build.build.final-library.name")
    private String ndkFinalLibraryName;
    @Parameter
    private String[] excludeJarResources;
    private Pattern[] excludeJarResourcesPatterns;
    @ConfigPojo(prefix="apk")
    @Parameter
    private Apk apk;
    private static final Pattern PATTERN_JAR_EXT = Pattern.compile("^.+\\.jar$", 2);
    private static final String DEX_SUFFIX = ".dex";
    private static final String CLASSES = "classes";
    @Parameter(property="android.nativeLibrariesDependenciesHardwareArchitectureDefault", defaultValue="armeabi")
    private String nativeLibrariesDependenciesHardwareArchitectureDefault;
    @Parameter
    private ResourceTransformer[] transformers;
    private Map<String, List<File>> jars = new HashMap<String, List<File>>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.generateApk) {
            return;
        }
        ConfigHandler cfh = new ConfigHandler((Object)this, this.session, this.execution);
        cfh.parseConfiguration();
        this.generateIntermediateApk();
        if (this.excludeJarResources != null && this.excludeJarResources.length > 0) {
            this.getLog().debug((CharSequence)("Compiling " + this.excludeJarResources.length + " patterns"));
            this.excludeJarResourcesPatterns = new Pattern[this.excludeJarResources.length];
            for (int index = 0; index < this.excludeJarResources.length; ++index) {
                this.excludeJarResourcesPatterns[index] = Pattern.compile(this.excludeJarResources[index]);
            }
        }
        File outputFile = new File(this.outputApk);
        boolean signWithDebugKeyStore = this.getAndroidSigner().isSignWithDebugKeyStore();
        if (this.getAndroidSigner().shouldCreateBothSignedAndUnsignedApk()) {
            this.getLog().info((CharSequence)("Creating debug key signed apk file " + outputFile));
            this.createApkFile(outputFile, true);
            File unsignedOutputFile = new File(this.targetDirectory, this.finalName + "-unsigned." + "apk");
            this.getLog().info((CharSequence)("Creating additional unsigned apk file " + unsignedOutputFile));
            this.createApkFile(unsignedOutputFile, false);
            this.projectHelper.attachArtifact(this.project, unsignedOutputFile, this.classifier == null ? "unsigned" : this.classifier + "_unsigned");
        } else {
            this.createApkFile(outputFile, signWithDebugKeyStore);
        }
        if (this.classifier == null) {
            this.project.getArtifact().setFile(outputFile);
        } else {
            this.projectHelper.attachArtifact(this.project, outputFile, this.classifier);
        }
    }

    void createApkFile(File outputFile, boolean signWithDebugKeyStore) throws MojoExecutionException {
        File dexFile = new File(this.targetDirectory, "classes.dex");
        if (!dexFile.exists()) {
            dexFile = new File(this.targetDirectory, "classes.zip");
        }
        File zipArchive = new File(this.targetDirectory, this.finalName + ".ap_");
        ArrayList<File> sourceFolders = new ArrayList<File>();
        if (this.sourceDirectories != null) {
            sourceFolders.addAll(Arrays.asList(this.sourceDirectories));
        }
        ArrayList<File> jarFiles = new ArrayList<File>();
        Collection<File> nativeFolders = this.getNativeLibraryFolders();
        this.getLog().info((CharSequence)("Adding native libraries : " + nativeFolders));
        this.doAPKWithAPKBuilder(outputFile, dexFile, zipArchive, sourceFolders, jarFiles, nativeFolders, signWithDebugKeyStore);
        if (this.apkMetaInf != null) {
            File outputJar = new File(this.outputApk.substring(0, this.outputApk.length() - 3) + "jar");
            if (outputJar.exists()) {
                jarFiles.add(outputJar);
            } else {
                this.getLog().warn((CharSequence)("Output jar doesn't exist:" + outputJar));
            }
            try {
                this.addMetaInf(outputFile, jarFiles);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not add META-INF resources.", (Exception)e);
            }
        }
    }

    private void addMetaInf(File outputFile, ArrayList<File> jarFiles) throws IOException {
        File tmp = File.createTempFile(outputFile.getName(), ".add", outputFile.getParentFile());
        FileOutputStream fos = new FileOutputStream(tmp);
        JarOutputStream zos = new JarOutputStream(fos);
        HashSet<String> entries = new HashSet<String>();
        this.updateWithMetaInf(zos, outputFile, entries, false);
        for (File f : jarFiles) {
            this.updateWithMetaInf(zos, f, entries, true);
        }
        if (this.transformers != null) {
            for (ResourceTransformer transformer : this.transformers) {
                if (!transformer.hasTransformedResource()) continue;
                transformer.modifyOutputStream(zos);
            }
        }
        zos.close();
        outputFile.delete();
        if (!tmp.renameTo(outputFile)) {
            throw new IOException(String.format("Cannot rename %s to %s", tmp, outputFile.getName()));
        }
    }

    private void updateWithMetaInf(ZipOutputStream zos, File jarFile, Set<String> entries, boolean metaInfOnly) throws IOException {
        ZipFile zin = new ZipFile(jarFile);
        Enumeration<? extends ZipEntry> en = zin.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            if (ze.isDirectory()) continue;
            String zn = ze.getName();
            if (metaInfOnly && (!zn.startsWith("META-INF/") || !this.apkMetaInf.isIncluded(zn))) continue;
            boolean resourceTransformed = false;
            if (this.transformers != null) {
                for (ResourceTransformer transformer : this.transformers) {
                    if (!transformer.canTransformResource(zn)) continue;
                    this.getLog().info((CharSequence)("Transforming " + zn + " using " + transformer.getClass().getName()));
                    InputStream is = zin.getInputStream(ze);
                    transformer.processResource(zn, is, null);
                    is.close();
                    resourceTransformed = true;
                    break;
                }
            }
            if (resourceTransformed || metaInfOnly && this.extractDuplicates && !entries.add(zn)) continue;
            InputStream is = zin.getInputStream(ze);
            ZipEntry ne = ze.getMethod() == 0 ? new ZipEntry(ze) : new ZipEntry(zn);
            zos.putNextEntry(ne);
            ApkMojo.copyStreamWithoutClosing(is, zos);
            is.close();
            zos.closeEntry();
        }
        zin.close();
    }

    private void computeDuplicateFiles(File jar) throws IOException {
        ZipFile file = new ZipFile(jar);
        Enumeration<? extends ZipEntry> list = file.entries();
        while (list.hasMoreElements()) {
            ZipEntry ze = list.nextElement();
            if (ze.getName().contains("META-INF/") || ze.isDirectory()) continue;
            List<File> l = this.jars.get(ze.getName());
            if (l == null) {
                l = new ArrayList<File>();
                this.jars.put(ze.getName(), l);
            }
            l.add(jar);
        }
    }

    private void extractDuplicateFiles(List<File> jarFiles) throws IOException {
        this.getLog().debug((CharSequence)"Extracting duplicates");
        ArrayList<String> duplicates = new ArrayList<String>();
        ArrayList<File> jarToModify = new ArrayList<File>();
        for (String s : this.jars.keySet()) {
            List<File> l = this.jars.get(s);
            if (l.size() <= 1) continue;
            this.getLog().warn((CharSequence)("Duplicate file " + s + " : " + l));
            duplicates.add(s);
            for (int i = 0; i < l.size(); ++i) {
                if (jarToModify.contains(l.get(i))) continue;
                jarToModify.add(l.get(i));
            }
        }
        File tmp = new File(this.targetDirectory.getAbsolutePath(), "unpacked-embedded-jars");
        tmp.mkdirs();
        File duplicatesJar = new File(tmp, "duplicate-resources.jar");
        HashSet<String> duplicatesAdded = new HashSet<String>();
        duplicatesJar.createNewFile();
        FileOutputStream fos = new FileOutputStream(duplicatesJar);
        JarOutputStream zos = new JarOutputStream(fos);
        for (File file : jarToModify) {
            File newJar = this.removeDuplicatesFromJar(file, duplicates, duplicatesAdded, zos);
            this.getLog().debug((CharSequence)("Removed duplicates from " + newJar));
            if (newJar == null) continue;
            int index = jarFiles.indexOf(file);
            jarFiles.set(index, newJar);
        }
        if (this.transformers != null) {
            for (ResourceTransformer transformer : this.transformers) {
                if (!transformer.hasTransformedResource()) continue;
                transformer.modifyOutputStream(zos);
            }
        }
        zos.close();
        fos.close();
        if (!jarToModify.isEmpty() && duplicatesJar.length() > 0L) {
            jarFiles.add(duplicatesJar);
        }
    }

    private void doAPKWithAPKBuilder(File outputFile, File dexFile, File zipArchive, Collection<File> sourceFolders, List<File> jarFiles, Collection<File> nativeFolders, boolean signWithDebugKeyStore) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Building APK with internal APKBuilder");
        sourceFolders.add(this.projectOutputDirectory);
        for (Artifact artifact : this.getRelevantCompileArtifacts()) {
            this.getLog().debug((CharSequence)("Found artifact for APK :" + artifact));
            if (this.extractDuplicates) {
                try {
                    this.computeDuplicateFiles(artifact.getFile());
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)("Cannot compute duplicates files from " + artifact.getFile().getAbsolutePath()), (Throwable)e);
                }
            }
            jarFiles.add(artifact.getFile());
        }
        if (this.extractDuplicates) {
            try {
                this.extractDuplicateFiles(jarFiles);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Could not extract duplicates to duplicate-resources.jar", (Throwable)e);
            }
        }
        try {
            String debugKeyStore = signWithDebugKeyStore ? ApkBuilder.getDebugKeystore() : null;
            ApkBuilder apkBuilder = new ApkBuilder(outputFile, zipArchive, dexFile, debugKeyStore, null);
            if (this.apkDebug.booleanValue()) {
                apkBuilder.setDebugMode(true);
            }
            for (File sourceFolder : sourceFolders) {
                this.getLog().debug((CharSequence)("Adding source folder : " + sourceFolder));
                apkBuilder.addSourceFolder(sourceFolder);
            }
            for (File jarFile : jarFiles) {
                boolean excluded = false;
                if (this.excludeJarResourcesPatterns != null) {
                    String name = jarFile.getName();
                    this.getLog().debug((CharSequence)("Checking " + name + " against patterns"));
                    for (Pattern pattern : this.excludeJarResourcesPatterns) {
                        Matcher matcher = pattern.matcher(name);
                        if (matcher.matches()) {
                            this.getLog().debug((CharSequence)("Jar " + name + " excluded by pattern " + pattern));
                            excluded = true;
                            break;
                        }
                        this.getLog().debug((CharSequence)("Jar " + name + " not excluded by pattern " + pattern));
                    }
                }
                if (excluded) continue;
                if (jarFile.isDirectory()) {
                    this.getLog().debug((CharSequence)("Adding resources from jar folder : " + jarFile));
                    String[] filenames = jarFile.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return PATTERN_JAR_EXT.matcher(name).matches();
                        }
                    });
                    for (String filename : filenames) {
                        File innerJar = new File(jarFile, filename);
                        this.getLog().debug((CharSequence)("Adding resources from innerJar : " + innerJar));
                        apkBuilder.addResourcesFromJar(innerJar);
                    }
                    continue;
                }
                this.getLog().debug((CharSequence)("Adding resources from : " + jarFile));
                apkBuilder.addResourcesFromJar(jarFile);
            }
            this.addSecondaryDexes(dexFile, apkBuilder);
            for (File nativeFolder : nativeFolders) {
                this.getLog().debug((CharSequence)("Adding native library : " + nativeFolder));
                apkBuilder.addNativeLibraries(nativeFolder);
            }
            apkBuilder.sealApk();
        }
        catch (ApkCreationException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (DuplicateFileException e) {
            String msg = String.format("Duplicated file: %s, found in archive %s and %s", e.getArchivePath(), e.getFile1(), e.getFile2());
            throw new MojoExecutionException(msg, (Exception)((Object)e));
        }
        catch (SealedApkException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void addSecondaryDexes(File dexFile, ApkBuilder apkBuilder) throws ApkCreationException, SealedApkException, DuplicateFileException {
        int dexNumber = 2;
        String dexFileName = this.getNextDexFileName(dexNumber);
        File secondDexFile = this.createNextDexFile(dexFile, dexFileName);
        while (secondDexFile.exists()) {
            apkBuilder.addFile(secondDexFile, dexFileName);
            dexFileName = this.getNextDexFileName(++dexNumber);
            secondDexFile = this.createNextDexFile(dexFile, dexFileName);
        }
    }

    private File createNextDexFile(File dexFile, String dexFileName) {
        return new File(dexFile.getParentFile(), dexFileName);
    }

    private String getNextDexFileName(int dexNumber) {
        return CLASSES + dexNumber + DEX_SUFFIX;
    }

    private File removeDuplicatesFromJar(File in, List<String> duplicates, Set<String> duplicatesAdded, ZipOutputStream duplicateZos) {
        ZipFile inZip;
        ZipOutputStream jos;
        FileOutputStream fos;
        String target = this.targetDirectory.getAbsolutePath();
        File tmp = new File(target, "unpacked-embedded-jars");
        tmp.mkdirs();
        File out = new File(tmp, in.getName());
        if (out.exists()) {
            return out;
        }
        try {
            out.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fos = new FileOutputStream(out);
            jos = new ZipOutputStream(fos);
        }
        catch (FileNotFoundException e1) {
            this.getLog().error((CharSequence)("Cannot remove duplicates : the output file " + out.getAbsolutePath() + " does not found"));
            return null;
        }
        try {
            inZip = new ZipFile(in);
            Enumeration<? extends ZipEntry> entries = inZip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!duplicates.contains(entry.getName())) {
                    jos.putNextEntry(entry);
                    InputStream currIn = inZip.getInputStream(entry);
                    ApkMojo.copyStreamWithoutClosing(currIn, jos);
                    currIn.close();
                    jos.closeEntry();
                    continue;
                }
                boolean resourceTransformed = false;
                if (this.transformers != null) {
                    for (ResourceTransformer transformer : this.transformers) {
                        if (!transformer.canTransformResource(entry.getName())) continue;
                        this.getLog().info((CharSequence)("Transforming " + entry.getName() + " using " + transformer.getClass().getName()));
                        InputStream currIn = inZip.getInputStream(entry);
                        transformer.processResource(entry.getName(), currIn, null);
                        currIn.close();
                        resourceTransformed = true;
                        break;
                    }
                }
                if (resourceTransformed || duplicatesAdded.add(entry.getName())) continue;
                duplicateZos.putNextEntry(entry);
                InputStream currIn = inZip.getInputStream(entry);
                ApkMojo.copyStreamWithoutClosing(currIn, duplicateZos);
                currIn.close();
                duplicateZos.closeEntry();
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Cannot removing duplicates : " + e.getMessage()));
            return null;
        }
        try {
            inZip.close();
            jos.close();
            fos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.getLog().info((CharSequence)(in.getName() + " rewritten without duplicates : " + out.getAbsolutePath()));
        return out;
    }

    private static void copyStreamWithoutClosing(InputStream in, OutputStream out) throws IOException {
        int n;
        int bufferSize = 4096;
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.write(b, 0, n);
        }
    }

    private Collection<File> getNativeLibraryFolders() throws MojoExecutionException {
        ArrayList<File> natives = new ArrayList<File>();
        if (this.nativeLibrariesDirectory.exists()) {
            this.copyLocalNativeLibraries(this.nativeLibrariesDirectory, this.ndkOutputDirectory);
        }
        Set<Artifact> artifacts = this.getNativeLibraryArtifacts();
        for (Artifact resolvedArtifact : artifacts) {
            if ("apklib".equals(resolvedArtifact.getType()) || "aar".equals(resolvedArtifact.getType())) {
                File folder = this.getUnpackedLibNativesFolder(resolvedArtifact);
                this.getLog().debug((CharSequence)("Adding native library folder " + folder));
                natives.add(folder);
            }
            for (String ndkArchitecture : AndroidNdk.NDK_ARCHITECTURES) {
                if (!NativeHelper.artifactHasHardwareArchitecture(resolvedArtifact, ndkArchitecture, this.nativeLibrariesDependenciesHardwareArchitectureDefault)) continue;
                this.copyNativeLibraryArtifact(resolvedArtifact, this.ndkOutputDirectory, ndkArchitecture);
            }
        }
        if (this.apkDebug.booleanValue()) {
            for (String ndkArchitecture : AndroidNdk.NDK_ARCHITECTURES) {
                this.copyGdbServer(this.ndkOutputDirectory, ndkArchitecture);
            }
        }
        if (this.ndkOutputDirectory.exists()) {
            this.getLog().debug((CharSequence)("Adding built native library folder " + this.ndkOutputDirectory));
            natives.add(this.ndkOutputDirectory);
        }
        return natives;
    }

    private Set<Artifact> getNativeLibraryArtifacts() throws MojoExecutionException {
        return this.getNativeHelper().getNativeDependenciesArtifacts(this, this.getUnpackedLibsDirectory(), true);
    }

    private void copyNativeLibraryArtifact(Artifact artifact, File destinationDirectory, String ndkArchitecture) throws MojoExecutionException {
        File artifactFile = this.getArtifactResolverHelper().resolveArtifactToFile(artifact);
        try {
            String filename;
            String artifactId = artifact.getArtifactId();
            String string = filename = artifactId.startsWith("lib") ? artifactId + ".so" : "lib" + artifactId + ".so";
            if (this.ndkFinalLibraryName != null && artifact.getFile().getName().startsWith("lib" + this.ndkFinalLibraryName)) {
                filename = artifact.getFile().getName();
            }
            File folder = new File(destinationDirectory, ndkArchitecture);
            File file = new File(folder, filename);
            this.getLog().debug((CharSequence)("Copying native dependency " + artifactId + " (" + artifact.getGroupId() + ") to " + file));
            FileUtils.copyFile((File)artifactFile, (File)file);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not copy native dependency.", (Exception)e);
        }
    }

    private void copyGdbServer(File destinationDirectory, String architecture) throws MojoExecutionException {
        try {
            File destDir = new File(destinationDirectory, architecture);
            if (destDir.exists()) {
                File gdbServerFile = this.getAndroidNdk().getGdbServer(architecture);
                File destFile = new File(destDir, "gdbserver");
                if (!destFile.exists()) {
                    this.getLog().debug((CharSequence)("Copying gdbServer to " + destFile));
                    FileUtils.copyFile((File)gdbServerFile, (File)destFile);
                } else {
                    this.getLog().info((CharSequence)"Note: gdbserver binary already exists at destination, will not copy over");
                }
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Error while copying gdbserver: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Error while copying gdbserver: " + e.getMessage(), e);
        }
    }

    private void copyLocalNativeLibraries(File localNativeLibrariesDirectory, File destinationDirectory) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Copying existing native libraries from " + localNativeLibrariesDirectory));
        try {
            IOFileFilter libSuffixFilter = FileFilterUtils.suffixFileFilter((String)".so");
            IOFileFilter gdbserverNameFilter = FileFilterUtils.nameFileFilter((String)"gdbserver");
            IOFileFilter orFilter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{libSuffixFilter, gdbserverNameFilter});
            IOFileFilter libFiles = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, orFilter});
            IOFileFilter filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{DirectoryFileFilter.DIRECTORY, libFiles});
            FileUtils.copyDirectory((File)localNativeLibrariesDirectory, (File)destinationDirectory, (FileFilter)filter);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not copy native libraries: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Could not copy native dependency.", (Exception)e);
        }
    }

    private void generateIntermediateApk() throws MojoExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File[] overlayDirectories = this.getResourceOverlayDirectories();
        File androidJar = this.getAndroidSdk().getAndroidJar();
        File outputFile = new File(this.targetDirectory, this.finalName + ".ap_");
        ArrayList<File> dependencyArtifactResDirectoryList = new ArrayList<File>();
        for (Artifact libraryArtifact : this.getTransitiveDependencyArtifacts("apklib", "aar")) {
            File libraryResDir = this.getUnpackedLibResourceFolder(libraryArtifact);
            if (!libraryResDir.exists()) continue;
            dependencyArtifactResDirectoryList.add(libraryResDir);
        }
        AaptCommandBuilder.AaptPackageCommandBuilder commandBuilder = AaptCommandBuilder.packageResources(this.getLog()).forceOverwriteExistingFiles().setPathToAndroidManifest(this.destinationManifestFile).addResourceDirectoriesIfExists(overlayDirectories).addResourceDirectoryIfExists(this.resourceDirectory).addResourceDirectoriesIfExists(dependencyArtifactResDirectoryList).autoAddOverlay().addRawAssetsDirectoryIfExists(this.combinedAssets).renameManifestPackage(this.renameManifestPackage).renameInstrumentationTargetPackage(this.renameInstrumentationTargetPackage).addExistingPackageToBaseIncludeSet(androidJar).setOutputApkFile(outputFile).addConfigurations(this.configurations).addExtraArguments(this.aaptExtraArgs).setVerbose(this.aaptVerbose).setDebugMode(!this.release);
        this.getLog().debug((CharSequence)(this.getAndroidSdk().getAaptPath() + " " + commandBuilder.toString()));
        try {
            executor.setCaptureStdOut(true);
            List<String> commands = commandBuilder.build();
            executor.executeCommand(this.getAndroidSdk().getAaptPath(), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    protected AndroidSigner getAndroidSigner() {
        if (this.sign == null) {
            return new AndroidSigner(this.signDebug);
        }
        return new AndroidSigner(this.sign.getDebug());
    }

    private MetaInf getDefaultMetaInf() {
        if (this.apkMetaIncludes != null && this.apkMetaIncludes.length > 0) {
            return new MetaInf().include(this.apkMetaIncludes);
        }
        return this.pluginMetaInf;
    }
}

