/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.simpligility.maven.plugins.android.common.DeviceHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AndroidTestRunListener
implements ITestRunListener {
    private static final String SCREENSHOT_SUFFIX = "_screenshot.png";
    private static final String INDENT = "  ";
    private static final String TAG_TESTSUITES = "testsuites";
    private static final String TAG_TESTSUITE = "testsuite";
    private static final String ATTR_TESTSUITE_ERRORS = "errors";
    private static final String ATTR_TESTSUITE_FAILURES = "failures";
    private static final String ATTR_TESTSUITE_IGNORED = "ignored";
    private static final String ATTR_TESTSUITE_HOSTNAME = "hostname";
    private static final String ATTR_TESTSUITE_NAME = "name";
    private static final String ATTR_TESTSUITE_TESTS = "tests";
    private static final String ATTR_TESTSUITE_TIME = "time";
    private static final String ATTR_TESTSUITE_TIMESTAMP = "timestamp";
    private static final String TAG_PROPERTIES = "properties";
    private static final String TAG_PROPERTY = "property";
    private static final String ATTR_PROPERTY_NAME = "name";
    private static final String ATTR_PROPERTY_VALUE = "value";
    private static final String TAG_TESTCASE = "testcase";
    private static final String ATTR_TESTCASE_NAME = "name";
    private static final String ATTR_TESTCASE_CLASSNAME = "classname";
    private static final String ATTR_TESTCASE_TIME = "time";
    private static final String TAG_ERROR = "error";
    private static final String TAG_FAILURE = "failure";
    private static final String ATTR_MESSAGE = "message";
    private static final String ATTR_TYPE = "type";
    private final NumberFormat timeFormatter = new DecimalFormat("#0.0000");
    private int testCount = 0;
    private int testRunCount = 0;
    private int testIgnoredCount = 0;
    private int testFailureCount = 0;
    private int testErrorCount = 0;
    private String testRunFailureCause = null;
    private final MavenProject project;
    private final IDevice device;
    private final Log log;
    private final Boolean createReport;
    private final Boolean takeScreenshotOnFailure;
    private final String screenshotsPathOnDevice;
    private final String reportSuffix;
    private final File targetDirectory;
    private final String deviceLogLinePrefix;
    private Document junitReport;
    private Node testSuiteNode;
    private Node currentTestCaseNode;
    private long currentTestCaseStartTime;
    private boolean threwException = false;
    private final StringBuilder exceptionMessages = new StringBuilder();

    public AndroidTestRunListener(MavenProject project, IDevice device, Log log, Boolean createReport, Boolean takeScreenshotOnFailure, String screenshotsPathOnDevice, String reportSuffix, File targetDirectory) {
        this.project = project;
        this.device = device;
        this.deviceLogLinePrefix = DeviceHelper.getDeviceLogLinePrefix(device);
        this.log = log;
        this.createReport = createReport;
        this.takeScreenshotOnFailure = takeScreenshotOnFailure;
        this.screenshotsPathOnDevice = screenshotsPathOnDevice;
        this.reportSuffix = reportSuffix;
        this.targetDirectory = targetDirectory;
    }

    public Log getLog() {
        return this.log;
    }

    public void testRunStarted(String runName, int tCount) {
        if (this.takeScreenshotOnFailure.booleanValue()) {
            this.executeOnAdbShell("rm -f " + this.screenshotsPathOnDevice + "/*screenshot.png");
            this.executeOnAdbShell("mkdir " + this.screenshotsPathOnDevice);
        }
        this.testCount = tCount;
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run started: " + runName + ", " + this.testCount + " tests:"));
        if (this.createReport.booleanValue()) {
            try {
                Attr propValueAttr;
                Attr propNameAttr;
                NamedNodeMap propertyAttributes;
                Element propertyNode;
                DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = null;
                parser = fact.newDocumentBuilder();
                this.junitReport = parser.newDocument();
                Element testSuitesNode = this.junitReport.createElement(TAG_TESTSUITES);
                this.junitReport.appendChild(testSuitesNode);
                this.testSuiteNode = this.junitReport.createElement(TAG_TESTSUITE);
                NamedNodeMap testSuiteAttributes = this.testSuiteNode.getAttributes();
                Attr nameAttr = this.junitReport.createAttribute("name");
                nameAttr.setValue(runName);
                testSuiteAttributes.setNamedItem(nameAttr);
                Attr hostnameAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_HOSTNAME);
                hostnameAttr.setValue(DeviceHelper.getDescriptiveName(this.device));
                testSuiteAttributes.setNamedItem(hostnameAttr);
                Element propertiesNode = this.junitReport.createElement(TAG_PROPERTIES);
                for (Map.Entry<Object, Object> systemProperty : System.getProperties().entrySet()) {
                    propertyNode = this.junitReport.createElement(TAG_PROPERTY);
                    propertyAttributes = propertyNode.getAttributes();
                    propNameAttr = this.junitReport.createAttribute("name");
                    propNameAttr.setValue(systemProperty.getKey().toString());
                    propertyAttributes.setNamedItem(propNameAttr);
                    propValueAttr = this.junitReport.createAttribute(ATTR_PROPERTY_VALUE);
                    propValueAttr.setValue(systemProperty.getValue().toString());
                    propertyAttributes.setNamedItem(propValueAttr);
                    propertiesNode.appendChild(propertyNode);
                }
                Map deviceProperties = this.device.getProperties();
                for (Map.Entry deviceProperty : deviceProperties.entrySet()) {
                    propertyNode = this.junitReport.createElement(TAG_PROPERTY);
                    propertyAttributes = propertyNode.getAttributes();
                    propNameAttr = this.junitReport.createAttribute("name");
                    propNameAttr.setValue((String)deviceProperty.getKey());
                    propertyAttributes.setNamedItem(propNameAttr);
                    propValueAttr = this.junitReport.createAttribute(ATTR_PROPERTY_VALUE);
                    propValueAttr.setValue((String)deviceProperty.getValue());
                    propertyAttributes.setNamedItem(propValueAttr);
                    propertiesNode.appendChild(propertyNode);
                }
                this.testSuiteNode.appendChild(propertiesNode);
                testSuitesNode.appendChild(this.testSuiteNode);
            }
            catch (ParserConfigurationException e) {
                this.threwException = true;
                this.exceptionMessages.append("Failed to create document");
                this.exceptionMessages.append(e.getMessage());
            }
        }
    }

    public void testIgnored(TestIdentifier testIdentifier) {
        ++this.testIgnoredCount;
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + testIdentifier.toString()));
    }

    public void testStarted(TestIdentifier testIdentifier) {
        ++this.testRunCount;
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + String.format("%1$s%1$sStart [%2$d/%3$d]: %4$s", INDENT, this.testRunCount, this.testCount, testIdentifier.toString())));
        if (this.createReport.booleanValue()) {
            this.currentTestCaseStartTime = new Date().getTime();
            this.currentTestCaseNode = this.junitReport.createElement(TAG_TESTCASE);
            NamedNodeMap testCaseAttributes = this.currentTestCaseNode.getAttributes();
            Attr classAttr = this.junitReport.createAttribute(ATTR_TESTCASE_CLASSNAME);
            classAttr.setValue(testIdentifier.getClassName());
            testCaseAttributes.setNamedItem(classAttr);
            Attr methodAttr = this.junitReport.createAttribute("name");
            methodAttr.setValue(testIdentifier.getTestName());
            testCaseAttributes.setNamedItem(methodAttr);
        }
    }

    public void testFailed(TestIdentifier testIdentifier, String trace) {
        if (this.takeScreenshotOnFailure.booleanValue()) {
            String suffix = "_error";
            String filepath = testIdentifier.getTestName() + suffix + SCREENSHOT_SUFFIX;
            this.executeOnAdbShell("screencap -p " + this.screenshotsPathOnDevice + "/" + filepath);
            this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + filepath + " saved."));
        }
        ++this.testErrorCount;
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + testIdentifier.toString()));
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + trace));
        if (this.createReport.booleanValue()) {
            Element errorFailureNode = this.junitReport.createElement(TAG_ERROR);
            NamedNodeMap errorfailureAttributes = errorFailureNode.getAttributes();
            errorFailureNode.setTextContent(trace);
            Attr msgAttr = this.junitReport.createAttribute(ATTR_MESSAGE);
            msgAttr.setValue(this.parseForMessage(trace));
            errorfailureAttributes.setNamedItem(msgAttr);
            Attr typeAttr = this.junitReport.createAttribute(ATTR_TYPE);
            typeAttr.setValue(this.parseForException(trace));
            errorfailureAttributes.setNamedItem(typeAttr);
            this.currentTestCaseNode.appendChild(errorFailureNode);
        }
    }

    public void testAssumptionFailure(TestIdentifier testIdentifier, String trace) {
        if (this.takeScreenshotOnFailure.booleanValue()) {
            String suffix = "_failure";
            String filepath = testIdentifier.getTestName() + suffix + SCREENSHOT_SUFFIX;
            this.executeOnAdbShell("screencap -p " + this.screenshotsPathOnDevice + "/" + filepath);
            this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + filepath + " saved."));
        }
        ++this.testFailureCount;
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + testIdentifier.toString()));
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + trace));
        if (this.createReport.booleanValue()) {
            Element errorFailureNode = this.junitReport.createElement(TAG_FAILURE);
            NamedNodeMap errorfailureAttributes = errorFailureNode.getAttributes();
            errorFailureNode.setTextContent(trace);
            Attr msgAttr = this.junitReport.createAttribute(ATTR_MESSAGE);
            msgAttr.setValue(this.parseForMessage(trace));
            errorfailureAttributes.setNamedItem(msgAttr);
            Attr typeAttr = this.junitReport.createAttribute(ATTR_TYPE);
            typeAttr.setValue(this.parseForException(trace));
            errorfailureAttributes.setNamedItem(typeAttr);
            this.currentTestCaseNode.appendChild(errorFailureNode);
        }
    }

    private void executeOnAdbShell(String command) {
        try {
            this.device.executeShellCommand(command, new IShellOutputReceiver(){

                public boolean isCancelled() {
                    return false;
                }

                public void flush() {
                }

                public void addOutput(byte[] data, int offset, int length) {
                }
            });
        }
        catch (TimeoutException e) {
            this.getLog().error((Throwable)e);
        }
        catch (AdbCommandRejectedException e) {
            this.getLog().error((Throwable)e);
        }
        catch (ShellCommandUnresponsiveException e) {
            this.getLog().error((Throwable)e);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }

    public void testEnded(TestIdentifier testIdentifier, Map<String, String> testMetrics) {
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + String.format("%1$s%1$sEnd [%2$d/%3$d]: %4$s", INDENT, this.testRunCount, this.testCount, testIdentifier.toString())));
        this.logMetrics(testMetrics);
        if (this.createReport.booleanValue()) {
            this.testSuiteNode.appendChild(this.currentTestCaseNode);
            NamedNodeMap testCaseAttributes = this.currentTestCaseNode.getAttributes();
            Attr timeAttr = this.junitReport.createAttribute("time");
            long now = new Date().getTime();
            double seconds = (double)(now - this.currentTestCaseStartTime) / 1000.0;
            timeAttr.setValue(this.timeFormatter.format(seconds));
            testCaseAttributes.setNamedItem(timeAttr);
        }
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run ended: " + elapsedTime + " ms"));
        if (this.hasFailuresOrErrors()) {
            this.getLog().error((CharSequence)(this.deviceLogLinePrefix + INDENT + "FAILURES!!!"));
        }
        this.getLog().info((CharSequence)("  Tests run: " + this.testRunCount + (this.testRunCount < this.testCount ? " (of " + this.testCount + ")" : "") + ",  Failures: " + this.testFailureCount + ",  Errors: " + this.testErrorCount + ",  Ignored: " + this.testIgnoredCount));
        if (this.createReport.booleanValue()) {
            NamedNodeMap testSuiteAttributes = this.testSuiteNode.getAttributes();
            Attr testCountAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_TESTS);
            testCountAttr.setValue(Integer.toString(this.testCount));
            testSuiteAttributes.setNamedItem(testCountAttr);
            Attr testFailuresAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_FAILURES);
            testFailuresAttr.setValue(Integer.toString(this.testFailureCount));
            testSuiteAttributes.setNamedItem(testFailuresAttr);
            Attr testErrorsAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_ERRORS);
            testErrorsAttr.setValue(Integer.toString(this.testErrorCount));
            testSuiteAttributes.setNamedItem(testErrorsAttr);
            Attr testIgnoredAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_IGNORED);
            testIgnoredAttr.setValue(Integer.toString(this.testIgnoredCount));
            testSuiteAttributes.setNamedItem(testIgnoredAttr);
            Attr timeAttr = this.junitReport.createAttribute("time");
            timeAttr.setValue(this.timeFormatter.format((double)elapsedTime / 1000.0));
            testSuiteAttributes.setNamedItem(timeAttr);
            Attr timeStampAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_TIMESTAMP);
            timeStampAttr.setValue(new Date().toString());
            testSuiteAttributes.setNamedItem(timeStampAttr);
        }
        this.logMetrics(runMetrics);
        if (this.createReport.booleanValue()) {
            this.writeJunitReportToFile();
        }
    }

    public void testRunFailed(String errorMessage) {
        this.testRunFailureCause = errorMessage;
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run failed: " + errorMessage));
    }

    public void testRunStopped(long elapsedTime) {
        this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + "Run stopped:" + elapsedTime));
    }

    private String parseForMessage(String trace) {
        if (StringUtils.isNotBlank((String)trace)) {
            boolean hasMessage;
            String newline = "\r\n";
            int messageEnd = trace.indexOf(newline);
            boolean bl = hasMessage = !trace.startsWith("junit.") && messageEnd > 0;
            if (hasMessage) {
                int messageStart = trace.indexOf(":") + 2;
                if (messageStart > messageEnd && messageStart > (messageEnd = trace.indexOf(newline + "at"))) {
                    messageStart = 0;
                }
                return trace.substring(messageStart, messageEnd);
            }
            return "";
        }
        return "";
    }

    private String parseForException(String trace) {
        if (StringUtils.isNotBlank((String)trace)) {
            return trace.substring(0, trace.indexOf(":"));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeJunitReportToFile() {
        block10: {
            TransformerFactory xfactory = TransformerFactory.newInstance();
            Transformer xformer = null;
            try {
                xformer = xfactory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            DOMSource source = new DOMSource(this.junitReport);
            FileWriter writer = null;
            try {
                String directory = this.targetDirectory + "/surefire-reports";
                FileUtils.forceMkdir((File)new File(directory));
                StringBuilder sb = new StringBuilder();
                sb.append(directory).append("/TEST-").append(DeviceHelper.getDescriptiveName(this.device));
                if (StringUtils.isNotBlank((String)this.reportSuffix)) {
                    sb.append(this.reportSuffix.replace("/", "").replace("\\", ""));
                }
                String fileName = sb.append(".xml").toString();
                File reportFile = new File(fileName);
                writer = new FileWriter(reportFile);
                StreamResult result = new StreamResult(writer);
                xformer.transform(source, result);
                this.getLog().info((CharSequence)(this.deviceLogLinePrefix + "Report file written to " + reportFile.getAbsolutePath()));
                IOUtils.closeQuietly((Writer)writer);
            }
            catch (IOException e) {
                this.threwException = true;
                this.exceptionMessages.append("Failed to write test report file");
                this.exceptionMessages.append(e.getMessage());
            }
            catch (TransformerException e2) {
                this.threwException = true;
                this.exceptionMessages.append("Failed to transform document to write to test report file");
                this.exceptionMessages.append(e2.getMessage());
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(writer);
            }
        }
    }

    private void logMetrics(Map<String, String> metrics) {
        for (Map.Entry<String, String> entry : metrics.entrySet()) {
            this.getLog().info((CharSequence)(this.deviceLogLinePrefix + INDENT + INDENT + entry.getKey() + ": " + entry.getValue()));
        }
    }

    public boolean hasFailuresOrErrors() {
        return this.testErrorCount > 0 || this.testFailureCount > 0;
    }

    public boolean testRunFailed() {
        return this.testRunFailureCause != null;
    }

    public String getTestRunFailureCause() {
        return this.testRunFailureCause;
    }

    public boolean threwException() {
        return this.threwException;
    }

    public String getExceptionMessages() {
        return this.exceptionMessages.toString();
    }
}

