/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.config.ConfigHandler;
import com.jayway.maven.plugins.android.config.ConfigPojo;
import com.jayway.maven.plugins.android.config.PullParameter;
import com.jayway.maven.plugins.android.configuration.Zipalign;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="zipalign")
public class ZipalignMojo
extends AbstractAndroidMojo {
    @ConfigPojo
    @Parameter
    private Zipalign zipalign;
    @Parameter(property="android.zipalign.skip")
    private Boolean zipalignSkip;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedSkip;
    @Parameter(property="android.zipalign.verbose")
    private Boolean zipalignVerbose;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedVerbose;
    @Parameter(property="android.zipalign.inputApk")
    private String zipalignInputApk;
    @PullParameter(defaultValueGetterMethod="getInputApkPath")
    private String parsedInputApk;
    @Parameter(property="android.zipalign.outputApk")
    private String zipalignOutputApk;
    @PullParameter(defaultValueGetterMethod="getOutputApkPath")
    private String parsedOutputApk;
    private File apkFile;
    private File alignedApkFile;
    @Parameter(property="android.zipalign.classifier")
    private String zipalignClassifier;
    @PullParameter(defaultValue={"aligned"})
    private String parsedClassifier;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!SUPPORTED_PACKAGING_TYPES.contains(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Skipping zipalign on " + this.project.getPackaging()));
            return;
        }
        ConfigHandler configHandler = new ConfigHandler((Object)this, this.session, this.execution);
        configHandler.parseConfiguration();
        this.parsedInputApk = FilenameUtils.separatorsToSystem((String)this.parsedInputApk);
        this.parsedOutputApk = FilenameUtils.separatorsToSystem((String)this.parsedOutputApk);
        this.getLog().debug((CharSequence)("skip:" + this.parsedSkip));
        this.getLog().debug((CharSequence)("verbose:" + this.parsedVerbose));
        this.getLog().debug((CharSequence)("inputApk:" + this.parsedInputApk));
        this.getLog().debug((CharSequence)("outputApk:" + this.parsedOutputApk));
        this.getLog().debug((CharSequence)("classifier:" + this.parsedClassifier));
        if (this.parsedSkip.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping zipalign");
        } else {
            boolean outputToSameFile = this.sameOutputAsInput();
            CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
            executor.setLogger(this.getLog());
            String command = this.getAndroidSdk().getZipalignPath();
            ArrayList<String> parameters = new ArrayList<String>();
            if (this.parsedVerbose.booleanValue()) {
                parameters.add("-v");
            }
            parameters.add("-f");
            parameters.add("4");
            parameters.add(this.parsedInputApk);
            String outputApk = outputToSameFile ? this.getTemporaryOutputApkFilename() : this.parsedOutputApk;
            parameters.add(outputApk);
            try {
                this.getLog().info((CharSequence)("Running command: " + command));
                this.getLog().info((CharSequence)("with parameters: " + parameters));
                executor.setCaptureStdOut(true);
                executor.executeCommand(command, parameters);
                if (FileUtils.fileExists((String)outputApk)) {
                    if (outputToSameFile) {
                        try {
                            FileUtils.rename((File)new File(outputApk), (File)new File(this.parsedInputApk));
                        }
                        catch (IOException e) {
                            this.getLog().error((CharSequence)("Failed to replace original apk with aligned " + this.getFullPathWithName(outputApk)), (Throwable)e);
                        }
                    } else {
                        this.projectHelper.attachArtifact(this.project, "apk", this.parsedClassifier, new File(outputApk));
                        this.getLog().info((CharSequence)("Attach " + this.getFullPathWithName(outputApk) + " as '" + this.parsedClassifier + "' to the project"));
                    }
                } else {
                    this.getLog().error((CharSequence)("Cannot attach " + this.getFullPathWithName(outputApk) + " to the project" + " - The file does not exist"));
                }
            }
            catch (ExecutionException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
    }

    private String getFullPathWithName(String filename) {
        return FilenameUtils.getFullPath((String)filename) + FilenameUtils.getName((String)filename);
    }

    private boolean sameOutputAsInput() {
        return this.getFullPathWithName(this.parsedInputApk).equals(this.getFullPathWithName(this.parsedOutputApk));
    }

    private String getTemporaryOutputApkFilename() {
        return this.parsedOutputApk.substring(0, this.parsedOutputApk.lastIndexOf(46)) + "-aligned-temp.apk";
    }

    private String getInputApkPath() {
        if (this.apkFile == null) {
            this.apkFile = new File(this.targetDirectory, this.finalName + "." + "apk");
        }
        return this.apkFile.getAbsolutePath();
    }

    private String getOutputApkPath() {
        if (this.alignedApkFile == null) {
            this.alignedApkFile = new File(this.targetDirectory, this.finalName + "-aligned." + "apk");
        }
        return this.alignedApkFile.getAbsolutePath();
    }
}

