/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase09package;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.common.AaptCommandBuilder;
import com.jayway.maven.plugins.android.common.NativeHelper;
import com.jayway.maven.plugins.android.config.PullParameter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;

@Mojo(name="apklib", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ApklibMojo
extends AbstractAndroidMojo {
    public static final String NATIVE_LIBRARIES_FOLDER = "libs";
    @Parameter
    private String classifier;
    @PullParameter
    @Parameter
    private String applicationMakefile;
    @PullParameter
    @Parameter(property="android.ndk.build.architecture")
    private String ndkArchitecture;
    @PullParameter
    @Parameter(property="android.ndk.build.native-classifier")
    private String ndkClassifier;
    private List<String> sourceFolders = new ArrayList<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        String out = this.targetDirectory.getPath();
        for (String src : this.project.getCompileSourceRoots()) {
            if (src.startsWith(out)) continue;
            this.sourceFolders.add(src);
        }
        this.generateIntermediateApk();
        File outputFile = this.createApkLibraryFile();
        if (this.classifier == null) {
            this.project.getArtifact().setFile(outputFile);
        } else {
            this.projectHelper.attachArtifact(this.project, outputFile, this.classifier);
        }
        if (this.attachJar) {
            File jarFile = new File(this.targetDirectory, this.finalName + ".jar");
            this.projectHelper.attachArtifact(this.project, "jar", this.project.getArtifact().getClassifier(), jarFile);
        }
    }

    private File createApkLibraryFile() throws MojoExecutionException {
        File apklibrary = new File(this.targetDirectory, this.finalName + "." + "apklib");
        FileUtils.deleteQuietly((File)apklibrary);
        try {
            File[] overlayDirectories;
            JarArchiver jarArchiver = new JarArchiver();
            jarArchiver.setDestFile(apklibrary);
            jarArchiver.addFile(this.androidManifestFile, "AndroidManifest.xml");
            this.addDirectory(jarArchiver, this.assetsDirectory, "assets");
            this.addDirectory(jarArchiver, this.resourceDirectory, "res");
            for (String src : this.sourceFolders) {
                this.addDirectory(jarArchiver, new File(src), "src");
            }
            for (File resOverlayDir : overlayDirectories = this.getResourceOverlayDirectories()) {
                if (resOverlayDir == null || !resOverlayDir.exists()) continue;
                this.addDirectory(jarArchiver, resOverlayDir, "res");
            }
            this.addJavaResources(jarArchiver, this.resources, "src");
            this.addNativeLibraries(jarArchiver);
            jarArchiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while creating .apklib file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while creating .apklib file.", (Exception)e);
        }
        return apklibrary;
    }

    private void addNativeLibraries(JarArchiver jarArchiver) throws MojoExecutionException {
        try {
            if (this.nativeLibrariesDirectory.exists()) {
                this.getLog().info((CharSequence)(this.nativeLibrariesDirectory + " exists, adding libraries."));
                this.addDirectory(jarArchiver, this.nativeLibrariesDirectory, NATIVE_LIBRARIES_FOLDER);
            } else {
                String[] ndkArchitectures;
                this.getLog().info((CharSequence)(this.nativeLibrariesDirectory + " does not exist, looking for libraries in target directory."));
                for (String architecture : ndkArchitectures = NativeHelper.getNdkArchitectures(this.ndkArchitecture, this.applicationMakefile, this.project.getBasedir())) {
                    File ndkLibsDirectory = new File(this.ndkOutputDirectory, architecture);
                    this.addSharedLibraries(jarArchiver, ndkLibsDirectory, architecture);
                }
            }
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("IOException while creating .apklib file.", (Exception)((Object)e));
        }
    }

    protected void addJavaResources(JarArchiver jarArchiver, List<Resource> javaResources, String prefix) throws IOException {
        for (Resource javaResource : javaResources) {
            this.addJavaResource(jarArchiver, javaResource, prefix);
        }
    }

    protected void addJavaResource(JarArchiver jarArchiver, Resource javaResource, String prefix) throws IOException {
        String apkLibUnpackBasePath;
        String resourcePath;
        File javaResourceDirectory;
        if (javaResource != null && (javaResourceDirectory = new File(javaResource.getDirectory())).exists() && !(resourcePath = javaResourceDirectory.getCanonicalPath()).startsWith(apkLibUnpackBasePath = this.getUnpackedLibsDirectory().getCanonicalPath())) {
            DefaultFileSet javaResourceFileSet = new DefaultFileSet();
            javaResourceFileSet.setDirectory(javaResourceDirectory);
            javaResourceFileSet.setPrefix(this.endWithSlash(prefix));
            jarArchiver.addFileSet((FileSet)javaResourceFileSet);
        }
    }

    protected String endWithSlash(String prefix) {
        if (!(prefix = StringUtils.defaultIfEmpty((String)prefix, (String)"/")).endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    protected void addDirectory(JarArchiver jarArchiver, File directory, String prefix) {
        if (directory != null && directory.exists()) {
            DefaultFileSet fileSet = new DefaultFileSet();
            fileSet.setPrefix(this.endWithSlash(prefix));
            fileSet.setDirectory(directory);
            fileSet.setExcludes(new String[]{"**/R.java", "**/BuildConfig.java"});
            jarArchiver.addFileSet((FileSet)fileSet);
            this.getLog().debug((CharSequence)("Added files from " + directory));
        }
    }

    protected void addSharedLibraries(JarArchiver jarArchiver, File directory, String architecture) {
        this.getLog().debug((CharSequence)("Searching for shared libraries in " + directory));
        File[] libFiles = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("lib") && name.endsWith(".so");
            }
        });
        if (libFiles != null) {
            for (File libFile : libFiles) {
                String dest = "libs/" + architecture + "/" + libFile.getName();
                this.getLog().debug((CharSequence)("Adding " + libFile + " as " + dest));
                jarArchiver.addFile(libFile, dest);
            }
        }
    }

    private void generateIntermediateApk() throws MojoExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File[] overlayDirectories = this.getResourceOverlayDirectories();
        File androidJar = this.getAndroidSdk().getAndroidJar();
        File outputFile = new File(this.targetDirectory, this.finalName + ".ap_");
        ArrayList<File> dependencyArtifactResDirectoryList = new ArrayList<File>();
        for (Artifact libraryArtifact : this.getTransitiveDependencyArtifacts("apklib", "aar")) {
            File apklibResDirectory = this.getUnpackedLibResourceFolder(libraryArtifact);
            if (!apklibResDirectory.exists()) continue;
            dependencyArtifactResDirectoryList.add(apklibResDirectory);
        }
        AaptCommandBuilder.AaptPackageCommandBuilder commandBuilder = AaptCommandBuilder.packageResources(this.getLog()).forceOverwriteExistingFiles().setPathToAndroidManifest(this.androidManifestFile).addResourceDirectoriesIfExists(overlayDirectories).addResourceDirectoryIfExists(this.resourceDirectory).addResourceDirectoriesIfExists(dependencyArtifactResDirectoryList).autoAddOverlay().addRawAssetsDirectoryIfExists(this.combinedAssets).addExistingPackageToBaseIncludeSet(androidJar).setOutputApkFile(outputFile).addConfigurations(this.configurations).setVerbose(this.aaptVerbose);
        this.getLog().debug((CharSequence)(this.getAndroidSdk().getAaptPath() + " " + commandBuilder.toString()));
        this.getLog().info((CharSequence)"Generating apklib");
        try {
            executor.setCaptureStdOut(true);
            List<String> commands = commandBuilder.build();
            executor.executeCommand(this.getAndroidSdk().getAaptPath(), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }
}

