/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

public class AndroidSigner {
    private final Debug debug;

    public AndroidSigner(String debug) {
        if (debug == null) {
            throw new IllegalArgumentException("android.sign.debug must be 'true', 'false', 'both' or 'auto'.");
        }
        try {
            this.debug = Debug.valueOf(debug.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("android.sign.debug must be 'true', 'false', 'both' or 'auto'.", e);
        }
    }

    public AndroidSigner(Debug debug) {
        this.debug = debug;
    }

    public boolean isSignWithDebugKeyStore() {
        if (this.debug == Debug.TRUE) {
            return true;
        }
        if (this.debug == Debug.BOTH) {
            return true;
        }
        if (this.debug == Debug.FALSE) {
            return false;
        }
        if (this.debug == Debug.AUTO) {
            return true;
        }
        throw new IllegalStateException("Could not determine whether to sign with debug keystore.");
    }

    public boolean shouldCreateBothSignedAndUnsignedApk() {
        return this.debug == Debug.BOTH;
    }

    public static enum Debug {
        TRUE,
        FALSE,
        BOTH,
        AUTO;

    }
}

