/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.sagacity.sqltoy.config.model.LabelIndexModel;
import org.sagacity.sqltoy.utils.ExpressionUtil;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class CalculateUtils {
    public static List<Integer> parseColumns(LabelIndexModel labelIndexMap, String columns, int dataWidth) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (StringUtil.isBlank(columns)) {
            return result;
        }
        String cols = columns.replaceAll("result\\.width\\(\\)", Integer.toString(dataWidth)).replaceAll("(?i)\\$\\{dataWidth\\}", Integer.toString(dataWidth));
        String[] colsAry = cols.split("\\,");
        for (int i = 0; i < colsAry.length; ++i) {
            String column = colsAry[i].toLowerCase();
            if (column.indexOf("..") != -1) {
                int step = 1;
                String[] beginToEnd = column.split("\\.\\.");
                int begin = 0;
                int end = 0;
                begin = NumberUtil.isInteger(beginToEnd[0]) ? Integer.parseInt(beginToEnd[0]) : (labelIndexMap.containsKey(beginToEnd[0]) ? labelIndexMap.get(beginToEnd[0]).intValue() : new BigDecimal(ExpressionUtil.calculate(beginToEnd[0]).toString()).intValue());
                String endColumnStr = beginToEnd[1];
                if (NumberUtil.isInteger(endColumnStr)) {
                    end = Integer.parseInt(endColumnStr);
                    if (end < 0) {
                        end = dataWidth + end - 1;
                    }
                } else {
                    int stepIndex = endColumnStr.indexOf("?");
                    if (stepIndex != -1) {
                        step = Integer.parseInt(endColumnStr.substring(stepIndex + 1).trim());
                        endColumnStr = endColumnStr.substring(0, stepIndex);
                    }
                    end = NumberUtil.isInteger(endColumnStr) ? Integer.parseInt(endColumnStr) : (labelIndexMap.containsKey(endColumnStr) ? labelIndexMap.get(endColumnStr).intValue() : new BigDecimal(ExpressionUtil.calculate(endColumnStr).toString()).intValue());
                }
                for (int j = begin; j <= end; j += step) {
                    if (result.contains(j)) continue;
                    result.add(j);
                }
                continue;
            }
            if (NumberUtil.isInteger(column)) {
                if (result.contains(Integer.parseInt(column))) continue;
                result.add(Integer.parseInt(column));
                continue;
            }
            Integer colIndex = labelIndexMap.containsKey(column) ? labelIndexMap.get(column) : Integer.valueOf(new BigDecimal(ExpressionUtil.calculate(column).toString()).intValue());
            if (result.contains(colIndex)) continue;
            result.add(colIndex);
        }
        return result;
    }
}

