/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.sharding;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.ShardingConfig;
import org.sagacity.sqltoy.config.model.ShardingDBModel;
import org.sagacity.sqltoy.config.model.ShardingGroupModel;
import org.sagacity.sqltoy.config.model.ShardingModel;
import org.sagacity.sqltoy.config.model.ShardingStrategyConfig;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.model.IgnoreCaseLinkedMap;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.plugins.id.IdGenerator;
import org.sagacity.sqltoy.plugins.sharding.ShardingStrategy;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingUtils {
    protected static final Logger logger = LoggerFactory.getLogger(ShardingUtils.class);

    public static ShardingModel getSharding(SqlToyContext sqlToyContext, Serializable entity, boolean wrapIdValue, DataSource dataSource) throws Exception {
        IgnoreCaseLinkedMap<String, Object> valueMap;
        ShardingStrategy shardingStrategy;
        ShardingStrategyConfig strategyConfig;
        ShardingConfig shardingConfig;
        ShardingModel shardingModel = new ShardingModel();
        shardingModel.setDataSource(dataSource);
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        shardingModel.setTableName(entityMeta.getTableName());
        if (wrapIdValue) {
            ShardingUtils.assignPK(sqlToyContext, entityMeta, entity);
        }
        if ((shardingConfig = entityMeta.getShardingConfig()) == null) {
            return shardingModel;
        }
        if (shardingConfig.getShardingDBStrategy() != null) {
            strategyConfig = shardingConfig.getShardingDBStrategy();
            shardingStrategy = sqlToyContext.getShardingStrategy(strategyConfig.getStrategy());
            if (shardingStrategy == null) {
                throw new IllegalArgumentException("POJO \u5bf9\u8c61:" + entity.getClass().getName() + " Sharding DB Strategy:" + strategyConfig.getStrategy() + " \u672a\u5b9a\u4e49,\u8bf7\u68c0\u67e5!");
            }
            valueMap = ShardingUtils.hashParams(strategyConfig.getAliasNames(), BeanUtil.reflectBeanToAry(entity, strategyConfig.getFields()));
            ShardingDBModel dbModel = shardingStrategy.getShardingDB(sqlToyContext, entity.getClass(), entityMeta.getTableName(), strategyConfig.getDecisionType(), valueMap);
            shardingModel.setDataSourceName(dbModel.getDataSourceName());
            if (dbModel.getDataSource() == null) {
                shardingModel.setDataSource(sqlToyContext.getDataSourceBean(dbModel.getDataSourceName()));
            } else {
                shardingModel.setDataSource(dbModel.getDataSource());
            }
        }
        if (shardingConfig.getShardingTableStrategy() != null) {
            strategyConfig = shardingConfig.getShardingTableStrategy();
            shardingStrategy = sqlToyContext.getShardingStrategy(strategyConfig.getStrategy());
            if (shardingStrategy == null) {
                throw new IllegalArgumentException("POJO \u5bf9\u8c61:" + entity.getClass().getName() + " Sharding Table Strategy:" + strategyConfig.getStrategy() + " \u672a\u5b9a\u4e49,\u8bf7\u68c0\u67e5!");
            }
            valueMap = ShardingUtils.hashParams(strategyConfig.getAliasNames(), BeanUtil.reflectBeanToAry(entity, strategyConfig.getFields()));
            String tableName = shardingStrategy.getShardingTable(sqlToyContext, entity.getClass(), entityMeta.getTableName(), strategyConfig.getDecisionType(), valueMap);
            if (StringUtil.isNotBlank(tableName)) {
                shardingModel.setTableName(tableName);
            }
        }
        return shardingModel;
    }

    public static Collection<ShardingGroupModel> groupShardings(SqlToyContext sqlToyContext, List<?> entities, EntityMeta entityMeta, DataSource dataSource) throws Exception {
        ShardingConfig shardingConfig = entityMeta.getShardingConfig();
        ShardingModel shardingModel = null;
        String entityTable = entityMeta.getTableName();
        if (shardingConfig == null) {
            ArrayList<ShardingGroupModel> result = new ArrayList<ShardingGroupModel>();
            ShardingGroupModel model = new ShardingGroupModel();
            shardingModel = new ShardingModel();
            shardingModel.setDataSource(dataSource);
            shardingModel.setTableName(entityTable);
            model.setShardingModel(shardingModel);
            model.setEntities(entities);
            result.add(model);
            return result;
        }
        Class entityClass = entityMeta.getEntityClass();
        boolean hasDB = false;
        ShardingStrategy dbStrategy = null;
        List<Object[]> shardingDBValues = null;
        ShardingStrategyConfig dbConfig = shardingConfig.getShardingDBStrategy();
        if (dbConfig != null) {
            hasDB = true;
            dbStrategy = sqlToyContext.getShardingStrategy(dbConfig.getStrategy());
            if (dbStrategy == null) {
                throw new IllegalArgumentException("POJO \u5bf9\u8c61:" + entityClass.getName() + " Sharding DB Strategy:" + dbConfig.getStrategy() + " \u672a\u5b9a\u4e49,\u8bf7\u68c0\u67e5!");
            }
            shardingDBValues = BeanUtil.reflectBeansToInnerAry(entities, dbConfig.getFields(), null, null);
        }
        boolean hasTable = false;
        ShardingStrategy tableStrategy = null;
        ShardingStrategyConfig tableConfig = shardingConfig.getShardingTableStrategy();
        List<Object[]> shardingTableValues = null;
        if (tableConfig != null) {
            hasTable = true;
            tableStrategy = sqlToyContext.getShardingStrategy(tableConfig.getStrategy());
            if (tableStrategy == null) {
                throw new IllegalArgumentException("POJO \u5bf9\u8c61:" + entityClass.getName() + " Sharding Table Strategy:" + tableConfig.getStrategy() + " \u672a\u5b9a\u4e49,\u8bf7\u68c0\u67e5!");
            }
            shardingTableValues = BeanUtil.reflectBeansToInnerAry(entities, tableConfig.getFields(), null, null);
        }
        HashMap<String, ShardingGroupModel> shardingGroupMaps = new HashMap<String, ShardingGroupModel>();
        ShardingDBModel shardingDBModel = null;
        String tableName = null;
        String dataSourceName = null;
        for (int i = 0; i < entities.size(); ++i) {
            String dataGroupKey;
            IgnoreCaseLinkedMap<String, Object> valueMap;
            if (hasDB) {
                valueMap = ShardingUtils.hashParams(dbConfig.getAliasNames(), shardingDBValues.get(i));
                shardingDBModel = dbStrategy.getShardingDB(sqlToyContext, entityClass, entityTable, dbConfig.getDecisionType(), valueMap);
                dataSourceName = shardingDBModel.getDataSourceName();
            }
            if (hasTable) {
                valueMap = ShardingUtils.hashParams(tableConfig.getAliasNames(), shardingTableValues.get(i));
                tableName = tableStrategy.getShardingTable(sqlToyContext, entityClass, entityTable, tableConfig.getDecisionType(), valueMap);
            }
            if (shardingGroupMaps.containsKey(dataGroupKey = dataSourceName + tableName)) {
                ((ShardingGroupModel)shardingGroupMaps.get(dataGroupKey)).getEntities().add(entities.get(i));
                continue;
            }
            ShardingGroupModel groupModel = new ShardingGroupModel();
            groupModel.setKey(dataGroupKey);
            ArrayList items = new ArrayList();
            items.add(entities.get(i));
            groupModel.setEntities(items);
            shardingModel = new ShardingModel();
            if (hasDB) {
                shardingModel.setDataSourceName(dataSourceName);
                if (shardingDBModel.getDataSource() == null) {
                    shardingModel.setDataSource(sqlToyContext.getDataSourceBean(shardingDBModel.getDataSourceName()));
                } else {
                    shardingModel.setDataSource(shardingDBModel.getDataSource());
                }
            } else {
                shardingModel.setDataSource(dataSource);
            }
            if (hasTable && StringUtil.isNotBlank(tableName)) {
                shardingModel.setTableName(tableName);
            }
            groupModel.setShardingModel(shardingModel);
            shardingGroupMaps.put(dataGroupKey, groupModel);
        }
        return shardingGroupMaps.values();
    }

    public static DataSource getShardingDataSource(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DataSource dataSource) throws Exception {
        Object[] paramValues;
        DataSource shardingDataSource = dataSource;
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        ShardingStrategyConfig shardingConfig = null;
        if (null != sqlToyConfig.getDataSourceSharding()) {
            shardingConfig = sqlToyConfig.getDataSourceSharding();
        }
        if (null != extend.dbSharding) {
            shardingConfig = extend.dbSharding;
        }
        if (null == shardingConfig) {
            return shardingDataSource;
        }
        String[] paramNames = extend.getDataSourceShardingParamsName();
        IgnoreCaseLinkedMap<String, Object> valueMap = ShardingUtils.hashParams(paramNames, paramValues = extend.getDataSourceShardingParamsValue());
        DataSource result = ShardingUtils.getShardingDataSource(sqlToyContext, sqlToyConfig, shardingConfig, valueMap);
        if (result != null) {
            return result;
        }
        return shardingDataSource;
    }

    private static DataSource getShardingDataSource(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, ShardingStrategyConfig shardingConfig, IgnoreCaseLinkedMap<String, Object> valueMap) {
        ShardingDBModel shardingDBModel;
        if (shardingConfig == null) {
            return null;
        }
        ShardingStrategy shardingStrategy = sqlToyContext.getShardingStrategy(shardingConfig.getStrategy());
        if (shardingStrategy == null) {
            return null;
        }
        IgnoreCaseLinkedMap<String, Object> realDataMap = null;
        if (shardingConfig.getFields() != null) {
            realDataMap = new IgnoreCaseLinkedMap();
            int n = shardingConfig.getFields().length;
            for (int i = 0; i < n; ++i) {
                realDataMap.put(shardingConfig.getAliasNames()[i], valueMap.get(shardingConfig.getFields()[i]));
            }
        } else {
            realDataMap = valueMap;
        }
        if ((shardingDBModel = shardingStrategy.getShardingDB(sqlToyContext, null, sqlToyConfig.getId(), shardingConfig.getDecisionType(), realDataMap)).getDataSource() != null) {
            return shardingDBModel.getDataSource();
        }
        return sqlToyContext.getDataSourceBean(shardingDBModel.getDataSourceName());
    }

    public static void replaceShardingSqlToyConfig(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, List<ShardingStrategyConfig> tableShardings, String dialect, String[] paramNames, Object[] paramValues) {
        if (tableShardings == null || tableShardings.isEmpty()) {
            return;
        }
        HashMap<String, String> shardingTableMap = ShardingUtils.getShardingTables(sqlToyContext, tableShardings, paramNames, paramValues);
        if (shardingTableMap == null || shardingTableMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, String>> iter = shardingTableMap.entrySet().iterator();
        boolean hasReplace = false;
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String sqlTable = entry.getKey();
            String targetTable = entry.getValue();
            if (targetTable == null || "".equals(targetTable.trim()) || sqlTable.equalsIgnoreCase(targetTable)) continue;
            sqlToyConfig.setCountSql(ShardingUtils.matchReplace(sqlToyConfig.getCountSql(dialect), sqlTable, targetTable));
            sqlToyConfig.setSql(ShardingUtils.matchReplace(sqlToyConfig.getSql(dialect), sqlTable, targetTable));
            sqlToyConfig.setFastSql(ShardingUtils.matchReplace(sqlToyConfig.getFastSql(dialect), sqlTable, targetTable));
            sqlToyConfig.setFastPreSql(ShardingUtils.matchReplace(sqlToyConfig.getFastPreSql(dialect), sqlTable, targetTable));
            sqlToyConfig.setFastTailSql(ShardingUtils.matchReplace(sqlToyConfig.getFastTailSql(dialect), sqlTable, targetTable));
            sqlToyConfig.setFastWithSql(ShardingUtils.matchReplace(sqlToyConfig.getFastWithSql(dialect), sqlTable, targetTable));
            hasReplace = true;
        }
        if (hasReplace) {
            sqlToyConfig.clearDialectSql();
            sqlToyConfig.setDialect(dialect);
        }
    }

    public static String replaceShardingTables(SqlToyContext sqlToyContext, String sql, List<ShardingStrategyConfig> tableShardings, String[] paramNames, Object[] paramValues) {
        if (tableShardings == null || tableShardings.isEmpty()) {
            return sql;
        }
        HashMap<String, String> shardingTableMap = ShardingUtils.getShardingTables(sqlToyContext, tableShardings, paramNames, paramValues);
        if (shardingTableMap == null || shardingTableMap.isEmpty()) {
            return sql;
        }
        Iterator<Map.Entry<String, String>> iter = shardingTableMap.entrySet().iterator();
        String resultSql = sql;
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String sqlTable = entry.getKey();
            String targetTable = entry.getValue();
            resultSql = ShardingUtils.matchReplace(resultSql, sqlTable, targetTable);
        }
        return resultSql;
    }

    private static HashMap<String, String> getShardingTables(SqlToyContext sqlToyContext, List<ShardingStrategyConfig> tableShardings, String[] paramNames, Object[] paramValues) {
        if (tableShardings == null || tableShardings.isEmpty()) {
            return null;
        }
        IgnoreCaseLinkedMap<String, Object> valueMap = ShardingUtils.hashParams(paramNames, paramValues);
        HashMap<String, String> tableMap = new HashMap<String, String>();
        IgnoreCaseLinkedMap<String, Object> realDataMap = null;
        for (ShardingStrategyConfig shardingModel : tableShardings) {
            ShardingStrategy shardingStrategy = sqlToyContext.getShardingStrategy(shardingModel.getStrategy());
            if (shardingStrategy != null) {
                int i;
                String[] tables = shardingModel.getTables();
                if (shardingModel.getFields() != null) {
                    realDataMap = new IgnoreCaseLinkedMap();
                    int n = shardingModel.getFields().length;
                    for (i = 0; i < n; ++i) {
                        realDataMap.put(shardingModel.getAliasNames()[i], valueMap.get(shardingModel.getFields()[i]));
                    }
                } else {
                    realDataMap = valueMap;
                }
                for (i = 0; i < tables.length; ++i) {
                    String table = tables[i];
                    String shardingTable = shardingStrategy.getShardingTable(sqlToyContext, null, table, shardingModel.getDecisionType(), realDataMap);
                    if (null == shardingTable || shardingTable.equalsIgnoreCase(table)) continue;
                    tableMap.put(table, shardingTable);
                }
                continue;
            }
            logger.error("sharding strategy:{} don't exist,please check sharding config!", (Object)shardingModel.getStrategy());
        }
        return tableMap;
    }

    private static String matchReplace(String sql, String sourceTable, String targetTable) {
        if (sql == null || "".equals(sql.trim())) {
            return sql;
        }
        Pattern p = Pattern.compile("(?i)\\W".concat(sourceTable).concat("\\W"));
        Matcher m = p.matcher(sql.concat(" "));
        StringBuilder lastSql = new StringBuilder();
        int start = 0;
        String tailSql = "";
        boolean isFind = false;
        while (m.find()) {
            isFind = true;
            lastSql.append(sql.substring(start, m.start() + 1)).append(targetTable);
            start = m.end() - 1;
            tailSql = sql.substring(start);
        }
        if (!isFind) {
            return sql;
        }
        return lastSql.append(tailSql).toString();
    }

    private static IgnoreCaseLinkedMap<String, Object> hashParams(String[] paramNames, Object[] paramValues) {
        IgnoreCaseLinkedMap<String, Object> valuesMap = new IgnoreCaseLinkedMap<String, Object>();
        if (paramValues == null || paramValues.length == 0) {
            return valuesMap;
        }
        if (paramNames == null || paramNames.length == 0) {
            for (int i = 0; i < paramValues.length; ++i) {
                valuesMap.put(Integer.toString(i), paramValues[i]);
            }
        } else {
            for (int i = 0; i < paramValues.length; ++i) {
                valuesMap.put(paramNames[i], paramValues[i]);
            }
        }
        return valuesMap;
    }

    public static void assignPK(SqlToyContext sqlToyContext, EntityMeta entityMeta, Serializable entity) throws Exception {
        ArrayList<Serializable> entities = new ArrayList<Serializable>();
        entities.add(entity);
        ShardingUtils.assignPKs(sqlToyContext, entityMeta, entities);
    }

    public static void assignPKs(SqlToyContext sqlToyContext, EntityMeta entityMeta, List<?> entities) throws Exception {
        IdGenerator idGenerator = entityMeta.getIdGenerator();
        String[] pks = entityMeta.getIdArray();
        if (idGenerator == null || pks == null || pks.length > 1) {
            return;
        }
        String table = entityMeta.getTableName();
        String idType = entityMeta.getIdType();
        int idLength = entityMeta.getIdLength();
        int sequenceSize = entityMeta.getBizIdSequenceSize();
        String[] reflectColumns = entityMeta.getFieldsArray();
        String signature = entityMeta.getBizIdSignature();
        Integer[] relatedColumnIndex = entityMeta.getBizIdRelatedColIndex();
        List<Object[]> ids = BeanUtil.reflectBeansToInnerAry(entities, pks, null, null);
        Object[] relatedColValue = null;
        for (int i = 0; i < entities.size(); ++i) {
            Object pkValue = ids.get(i)[0];
            if (pkValue != null && !"".equals(pkValue.toString().trim())) continue;
            if (entityMeta.isBizIdEqPK()) {
                Object[] fullParamValues = BeanUtil.reflectBeanToAry(entities.get(i), reflectColumns);
                if (relatedColumnIndex != null) {
                    relatedColValue = new Object[relatedColumnIndex.length];
                    for (int meter = 0; meter < relatedColumnIndex.length; ++meter) {
                        relatedColValue[meter] = fullParamValues[relatedColumnIndex[meter]];
                        if (relatedColValue[meter] != null) continue;
                        throw new IllegalArgumentException("\u5bf9\u8c61:" + entityMeta.getEntityClass().getName() + " \u751f\u6210\u4e1a\u52a1\u4e3b\u952e\u4f9d\u8d56\u7684\u5173\u8054\u5b57\u6bb5:" + relatedColumnIndex[meter] + " \u503c\u4e3anull!");
                    }
                }
            }
            BeanUtil.setProperty(entities.get(i), pks[0], idGenerator.getId(table, signature, entityMeta.getBizIdRelatedColumns(), relatedColValue, null, idType, idLength, sequenceSize));
        }
    }
}

