/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.overtime;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.sagacity.sqltoy.model.OverTimeSql;
import org.sagacity.sqltoy.model.PriorityLimitSizeQueue;
import org.sagacity.sqltoy.plugins.OverTimeSqlHandler;

public class DefaultOverTimeHandler
implements OverTimeSqlHandler {
    private PriorityLimitSizeQueue<OverTimeSql> queues = new PriorityLimitSizeQueue<OverTimeSql>(500, new Comparator<OverTimeSql>(){

        @Override
        public int compare(OverTimeSql o1, OverTimeSql o2) {
            return Long.valueOf(o1.getTakeTime() - o2.getTakeTime()).intValue();
        }
    });
    private HashMap<String, OverTimeSql> slowSqlMap = new HashMap();

    @Override
    public void log(OverTimeSql overTimeSql) {
        String sqlId = overTimeSql.getId();
        if (null != sqlId && !"".equals(sqlId.trim())) {
            OverTimeSql preSql = this.slowSqlMap.get(sqlId);
            if (null == preSql) {
                overTimeSql.setAveTakeTime(new BigDecimal(overTimeSql.getTakeTime()));
                this.slowSqlMap.put(sqlId, overTimeSql);
            } else if (overTimeSql.getTakeTime() > preSql.getTakeTime()) {
                overTimeSql.setAveTakeTime(preSql.getAveTakeTime().multiply(new BigDecimal(preSql.getOverTimeCount())).add(new BigDecimal(overTimeSql.getTakeTime())).divide(new BigDecimal(preSql.getOverTimeCount() + 1L), 3, RoundingMode.HALF_UP));
                overTimeSql.setOverTimeCount(preSql.getOverTimeCount() + 1L);
                overTimeSql.setFirstLogTime(preSql.getFirstLogTime());
                this.slowSqlMap.put(sqlId, overTimeSql);
            } else {
                preSql.setAveTakeTime(preSql.getAveTakeTime().multiply(new BigDecimal(preSql.getOverTimeCount())).add(new BigDecimal(overTimeSql.getTakeTime())).divide(new BigDecimal(preSql.getOverTimeCount() + 1L), 3, RoundingMode.HALF_UP));
                preSql.setLogTime(overTimeSql.getLogTime());
                preSql.setOverTimeCount(preSql.getOverTimeCount() + 1L);
            }
        } else {
            this.queues.offer(overTimeSql);
        }
    }

    @Override
    public List<OverTimeSql> getSlowest(int size, boolean hasSqlId) {
        if (size < 1) {
            throw new IllegalArgumentException("\u53d6\u6700\u6162\u67e5\u8be2:size \u53c2\u6570\u5fc5\u987b>=1,\u5982\u679c\u8981\u83b7\u53d6\u5168\u90e8\uff0c\u53ef\u4f7f\u7528:Integer.MAX_VALUE");
        }
        if (!hasSqlId) {
            return this.getSlowest(size);
        }
        ArrayList<OverTimeSql> result = new ArrayList<OverTimeSql>();
        Iterator<OverTimeSql> iter = this.slowSqlMap.values().iterator();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        Collections.sort(result, new Comparator<OverTimeSql>(){

            @Override
            public int compare(OverTimeSql o1, OverTimeSql o2) {
                return Long.valueOf(o2.getTakeTime() - o1.getTakeTime()).intValue();
            }
        });
        if (size >= result.size()) {
            return result;
        }
        return result.subList(0, size - 1);
    }

    private List<OverTimeSql> getSlowest(int size) {
        ArrayList<OverTimeSql> result = new ArrayList<OverTimeSql>();
        Iterator<OverTimeSql> iter = this.queues.iterator();
        int index = 0;
        int start = this.queues.size() - size;
        if (start < 0) {
            start = 0;
        }
        while (iter.hasNext()) {
            OverTimeSql nextVal = iter.next();
            if (index >= start) {
                result.add(0, nextVal);
            }
            ++index;
        }
        return result;
    }
}

