/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.function.impl;

import java.util.regex.Pattern;
import org.sagacity.sqltoy.plugins.function.IFunction;
import org.sagacity.sqltoy.utils.StringUtil;

public class GroupConcat
extends IFunction {
    private static Pattern regex = Pattern.compile("(?i)\\W(group_concat|string_agg)\\(");
    private static Pattern separtorPattern = Pattern.compile("\\Wseparator\\W");

    @Override
    public String dialects() {
        return "";
    }

    @Override
    public Pattern regex() {
        return regex;
    }

    @Override
    public String wrap(int dialect, String functionName, boolean hasArgs, String ... args) {
        if (args == null || args.length == 0) {
            return this.IGNORE;
        }
        String tmp = args[args.length - 1];
        String sign = "','";
        int matchIndex = StringUtil.matchIndex(tmp.toLowerCase(), separtorPattern);
        if (matchIndex > 0) {
            sign = tmp.substring(matchIndex + 11).trim();
        }
        if (dialect == 50 || dialect == 51 || dialect == 70) {
            if ("string_agg".equals(functionName.toLowerCase())) {
                return this.IGNORE;
            }
            if (args.length > 1) {
                return " array_to_string(ARRAY_AGG(" + args[0] + ")," + args[1] + ") ";
            }
            if (matchIndex > 0) {
                return " array_to_string(ARRAY_AGG(" + args[0].substring(0, matchIndex) + ")," + sign + ") ";
            }
            return " array_to_string(ARRAY_AGG(" + args[0] + ")," + sign + ") ";
        }
        if (dialect == 40 || dialect == 90 || dialect == 42 || dialect == 170) {
            if ("group_concat".equals(functionName.toLowerCase())) {
                return this.IGNORE;
            }
            return " group_concat(" + args[0] + " separator " + args[1] + ") ";
        }
        return this.IGNORE;
    }
}

