/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.utils;

import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.utils.StringUtil;

public class H2DialectUtils {
    public static boolean isAssignPKValue(PKStrategy pkStrategy) {
        if (pkStrategy == null) {
            return true;
        }
        return !pkStrategy.equals((Object)PKStrategy.IDENTITY);
    }

    public static void wrapSelectFields(StringBuilder sql, String columnName, FieldMeta fieldMeta) {
        int jdbcType = fieldMeta.getType();
        int length = fieldMeta.getLength();
        if (jdbcType == 12) {
            sql.append("cast(? as varchar(" + length + "))");
        } else if (jdbcType == 1) {
            sql.append("cast(? as char(" + length + "))");
        } else if (jdbcType == 91) {
            sql.append("cast(? as date)");
        } else if (jdbcType == 2) {
            sql.append("cast(? as DECIMAL)");
        } else if (jdbcType == 3) {
            sql.append("cast(? as DECIMAL)");
        } else if (jdbcType == -5) {
            sql.append("cast(? as bigint)");
        } else if (jdbcType == 4 || jdbcType == -6) {
            sql.append("cast(? as INT)");
        } else if (jdbcType == 93) {
            sql.append("cast(? as timestamp)");
        } else if (jdbcType == 8) {
            sql.append("cast(? as double)");
        } else if (jdbcType == 6) {
            sql.append("cast(? as DOUBLE)");
        } else if (jdbcType == 92) {
            sql.append("cast(? as time)");
        } else if (jdbcType == 2005) {
            sql.append("cast(? as CLOB)");
        } else if (jdbcType == 16) {
            sql.append("cast(? as BOOLEAN)");
        } else if (jdbcType == -2) {
            sql.append("cast(? as BINARY)");
        } else if (jdbcType == 2004) {
            sql.append("cast(? as BLOB)");
        } else if (StringUtil.isNotBlank(fieldMeta.getNativeType())) {
            sql.append("cast(? as " + fieldMeta.getNativeType() + ")");
        } else {
            sql.append("?");
        }
        sql.append(" as ");
        sql.append(columnName);
    }
}

