/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.GenerateSqlHandler;
import org.sagacity.sqltoy.callback.ReflectPropsHandler;
import org.sagacity.sqltoy.callback.UpdateRowHandler;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.config.model.SqlWithAnalysis;
import org.sagacity.sqltoy.dialect.Dialect;
import org.sagacity.sqltoy.dialect.utils.DefaultDialectUtils;
import org.sagacity.sqltoy.dialect.utils.DialectExtUtils;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.dialect.utils.SqlServerDialectUtils;
import org.sagacity.sqltoy.model.ColumnMeta;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.StoreResult;
import org.sagacity.sqltoy.model.TableMeta;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.SqlUtilsExt;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerDialect
implements Dialect {
    protected final Logger logger = LoggerFactory.getLogger(SqlServerDialect.class);
    private static final String NVL_FUNCTION = "isnull";
    private static final Pattern ORDER_BY = Pattern.compile("(?i)\\Worder\\s*by\\W");

    @Override
    public boolean isUnique(SqlToyContext sqlToyContext, Serializable entity, String[] paramsNamed, Connection conn, Integer dbType, String tableName) {
        return DialectUtils.isUnique(sqlToyContext, entity, paramsNamed, conn, dbType, tableName, (entityMeta, realParamNamed, table, topSize) -> {
            String queryStr = DialectExtUtils.wrapUniqueSql(entityMeta, realParamNamed, dbType, table);
            return queryStr.replaceFirst("(?i)select ", "select top " + topSize + " ");
        });
    }

    @Override
    public QueryResult getRandomResult(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long totalCount, Long randomCount, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        return SqlServerDialectUtils.getRandomResult(sqlToyContext, sqlToyConfig, queryExecutor, decryptHandler, totalCount, randomCount, conn, dbType, dialect, fetchSize, maxRows);
    }

    @Override
    public QueryResult findPageBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long pageNo, Integer pageSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        int orderByIndex;
        String innerSql;
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        StringBuilder sql = new StringBuilder();
        boolean isNamed = sqlToyConfig.isNamedParam();
        String judgeOrderSql = innerSql = sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect);
        innerSql = SqlUtilsExt.markOriginalSql(innerSql);
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        sql.append(innerSql);
        if (isNamed) {
            SqlToyResult tmpResult = SqlConfigParseUtils.processSql(judgeOrderSql, extend.getParamsName(), extend.getParamsValue(sqlToyContext, sqlToyConfig), dialect);
            judgeOrderSql = tmpResult.getSql();
        }
        if ((orderByIndex = StringUtil.matchIndex(judgeOrderSql, ORDER_BY)) > 0) {
            orderByIndex = StringUtil.matchIndex(DialectUtils.clearDisturbSql(judgeOrderSql), ORDER_BY);
        }
        if (orderByIndex < 0) {
            sql.append(" order by NEWID() ");
        }
        sql.append(" offset ");
        sql.append(isNamed ? ":pageFirstParamName" : "?");
        sql.append(" rows fetch next ");
        sql.append(isNamed ? ":pageLastParamName" : "?");
        sql.append(" rows only");
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), (pageNo - 1L) * (long)pageSize.intValue(), pageSize, dialect);
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.page : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return this.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, null, dbType, dialect, fetchSize, maxRows);
    }

    @Override
    public QueryResult findTopBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Integer topSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        String innerSql;
        StringBuilder sql = new StringBuilder();
        String string = innerSql = sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect);
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        String partSql = " select top " + topSize + " ";
        if (sqlToyConfig.isHasWith()) {
            SqlWithAnalysis sqlWith = new SqlWithAnalysis(innerSql);
            sql.append(sqlWith.getWithSql());
            innerSql = sqlWith.getRejectWithSql();
        }
        boolean hasUnion = false;
        if (sqlToyConfig.isHasUnion()) {
            hasUnion = SqlUtil.hasUnion(innerSql, false);
        }
        innerSql = SqlUtilsExt.markOriginalSql(innerSql);
        if (hasUnion) {
            sql.append(partSql);
            sql.append(" " + SqlToyConstants.INTERMEDIATE_TABLE + ".* from (");
            sql.append(innerSql);
            sql.append(") as " + SqlToyConstants.INTERMEDIATE_TABLE + " ");
        } else {
            sql.append(innerSql.replaceFirst("(?i)select ", partSql));
        }
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), null, null, dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.top : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return this.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, null, dbType, dialect, fetchSize, maxRows);
    }

    @Override
    public QueryResult findBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, QueryExecutorExtend queryExecutorExtend, DecryptHandler decryptHandler, Connection conn, LockMode lockMode, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        String realSql = SqlServerDialectUtils.lockSql(sql, null, lockMode);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, realSql, paramsValue, queryExecutorExtend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    @Override
    public Long getCountBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, boolean isLastSql, Connection conn, Integer dbType, String dialect) throws Exception {
        return DialectUtils.getCountBySql(sqlToyContext, sqlToyConfig, sql, paramsValue, isLastSql, conn, dbType);
    }

    @Override
    public Long saveOrUpdate(SqlToyContext sqlToyContext, Serializable entity, String[] forceUpdateFields, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        ArrayList<Serializable> entities = new ArrayList<Serializable>();
        entities.add(entity);
        return this.saveOrUpdateAll(sqlToyContext, entities, sqlToyContext.getBatchSize(), null, forceUpdateFields, conn, dbType, dialect, autoCommit, tableName);
    }

    @Override
    public Long saveOrUpdateAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, String[] forceUpdateFields, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        return SqlServerDialectUtils.saveOrUpdateAll(sqlToyContext, entities, batchSize, reflectPropsHandler, forceUpdateFields, conn, dbType, autoCommit, tableName);
    }

    @Override
    public Long saveAllIgnoreExist(final SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, final Integer dbType, String dialect, Boolean autoCommit, final String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        return DialectUtils.saveAllIgnoreExist(sqlToyContext, entities, batchSize, entityMeta, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                String sql = SqlServerDialectUtils.getSaveIgnoreExistSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, entityMeta.getIdStrategy(), tableName, SqlServerDialect.NVL_FUNCTION, "@mySeqVariable", false);
                if (entityMeta.getIdStrategy() != null && entityMeta.getIdStrategy().equals((Object)PKStrategy.SEQUENCE)) {
                    sql = "DECLARE @mySeqVariable as numeric(20)=NEXT VALUE FOR " + entityMeta.getSequence() + " " + sql;
                }
                return sql.concat(";");
            }
        }, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public Serializable load(SqlToyContext sqlToyContext, Serializable entity, List<Class> cascadeTypes, LockMode lockMode, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        SqlToyConfig sqlToyConfig = sqlToyContext.getSqlToyConfig(entityMeta.getLoadSql(tableName), SqlType.search, dialect, null);
        String loadSql = sqlToyConfig.getSql(dialect);
        loadSql = SqlServerDialectUtils.lockSql(loadSql, entityMeta.getSchemaTable(tableName, dbType), lockMode);
        return DialectUtils.load(sqlToyContext, sqlToyConfig, loadSql, entityMeta, entity, cascadeTypes, conn, dbType);
    }

    @Override
    public List<?> loadAll(SqlToyContext sqlToyContext, List<?> entities, List<Class> cascadeTypes, LockMode lockMode, Connection conn, Integer dbType, String dialect, String tableName, int fetchSize, int maxRows) throws Exception {
        return DialectUtils.loadAll(sqlToyContext, entities, cascadeTypes, lockMode, conn, dbType, tableName, null, fetchSize, maxRows);
    }

    @Override
    public Object save(SqlToyContext sqlToyContext, Serializable entity, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return SqlServerDialectUtils.save(sqlToyContext, entity, conn, dbType, tableName);
    }

    @Override
    public Long saveAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        return SqlServerDialectUtils.saveAll(sqlToyContext, entities, reflectPropsHandler, conn, dbType, autoCommit, tableName);
    }

    @Override
    public Long update(SqlToyContext sqlToyContext, Serializable entity, String[] forceUpdateFields, boolean cascade, Class[] emptyCascadeClasses, HashMap<Class, String[]> subTableForceUpdateProps, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return SqlServerDialectUtils.update(sqlToyContext, entity, forceUpdateFields, cascade, emptyCascadeClasses, subTableForceUpdateProps, conn, dbType, tableName);
    }

    @Override
    public Long updateAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, String[] uniqueFields, String[] forceUpdateFields, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        return DialectUtils.updateAll(sqlToyContext, entities, batchSize, forceUpdateFields, reflectPropsHandler, NVL_FUNCTION, conn, dbType, autoCommit, tableName, false);
    }

    @Override
    public Serializable updateSaveFetch(SqlToyContext sqlToyContext, Serializable entity, UpdateRowHandler updateRowHandler, String[] uniqueProps, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return DefaultDialectUtils.updateSaveFetch(sqlToyContext, entity, updateRowHandler, uniqueProps, conn, dbType, dialect, tableName);
    }

    @Override
    public Long delete(SqlToyContext sqlToyContext, Serializable entity, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return DialectUtils.delete(sqlToyContext, entity, conn, dbType, tableName);
    }

    @Override
    public Long deleteAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        return DialectUtils.deleteAll(sqlToyContext, entities, batchSize, conn, dbType, autoCommit, tableName);
    }

    @Override
    public QueryResult updateFetch(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, UpdateRowHandler updateRowHandler, Connection conn, Integer dbType, String dialect, LockMode lockMode, int fetchSize, int maxRows) throws Exception {
        String realSql = SqlServerDialectUtils.lockSql(sql, null, lockMode == null ? LockMode.UPGRADE : lockMode);
        return DialectUtils.updateFetchBySql(sqlToyContext, sqlToyConfig, realSql, paramsValue, updateRowHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    @Override
    public StoreResult executeStore(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] inParamsValue, Integer[] outParamsType, boolean moreResult, Connection conn, Integer dbType, String dialect, int fetchSize) throws Exception {
        return DialectUtils.executeStore(sqlToyConfig, sqlToyContext, sql, inParamsValue, outParamsType, moreResult, conn, dbType, fetchSize);
    }

    @Override
    public List<ColumnMeta> getTableColumns(String catalog, String schema, String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        List<ColumnMeta> tableColumns = SqlServerDialectUtils.getTableColumns(catalog, schema, tableName, conn, dbType, dialect);
        Map<String, ColumnMeta> pkMap = DefaultDialectUtils.getTablePrimaryKeys(catalog, schema, tableName, conn, dbType, dialect);
        if (pkMap == null || pkMap.isEmpty()) {
            return tableColumns;
        }
        for (ColumnMeta colMeta : tableColumns) {
            ColumnMeta mapMeta = pkMap.get(colMeta.getColName());
            if (mapMeta == null) continue;
            colMeta.setPK(true);
        }
        return tableColumns;
    }

    @Override
    public List<TableMeta> getTables(String catalog, String schema, String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        return SqlServerDialectUtils.getTables(catalog, schema, (String)(tableName != null && "%".equals(tableName) ? null : tableName), conn, dbType, dialect);
    }
}

