/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.config.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sagacity.sqltoy.config.model.DataVersionConfig;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.FieldSecureConfig;
import org.sagacity.sqltoy.config.model.IndexModel;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.ShardingConfig;
import org.sagacity.sqltoy.config.model.TableCascadeModel;
import org.sagacity.sqltoy.model.IgnoreCaseSet;
import org.sagacity.sqltoy.model.SecureType;
import org.sagacity.sqltoy.plugins.id.IdGenerator;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class EntityMeta
implements Serializable {
    private static final long serialVersionUID = -1723897636996281118L;
    private Class entityClass;
    private String loadAllSql;
    private String schema;
    private String tableName;
    private String pkConstraint;
    private String[] idArray;
    private String[] fieldsArray;
    private Integer[] fieldsTypeArray;
    private String[] fieldsDefaultValue;
    private Boolean[] fieldsNullable;
    private String[] rejectIdFieldArray;
    private HashMap<String, FieldMeta> fieldsMeta = new HashMap();
    private HashMap<String, String> columnFieldMap = new HashMap();
    private HashMap<String, Integer> fieldIndexs = new HashMap();
    private String bizIdSignature;
    private String[] bizIdRelatedColumns = null;
    private Integer[] bizIdRelatedColIndex = null;
    private Integer bizIdLength;
    private Integer bizIdSequenceSize = -1;
    private PKStrategy idStrategy;
    private ShardingConfig shardingConfig;
    private String sequence;
    private IdGenerator idGenerator;
    private IdGenerator businessIdGenerator;
    private String businessIdField;
    private String loadSql;
    private String idNameWhereSql;
    private String idArgWhereSql;
    private List<TableCascadeModel> cascadeModels = new ArrayList<TableCascadeModel>();
    private Map<String, String[]> foreignFields;
    private Class[] cascadeTypes;
    private String idJavaType;
    private boolean hasBizIdConfig = false;
    private boolean bizIdEqPK = false;
    private String allColumnNames = "*";
    private List<FieldSecureConfig> secureFields = new ArrayList<FieldSecureConfig>();
    private IgnoreCaseSet secureColumns;
    private DataVersionConfig dataVersion;
    private String tenantField;
    private IndexModel[] indexModels;

    public String getLoadAllSql() {
        return this.loadAllSql;
    }

    public void setLoadAllSql(String loadAllSql) {
        this.loadAllSql = loadAllSql;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public HashMap<String, FieldMeta> getFieldsMeta() {
        return this.fieldsMeta;
    }

    public String getIdType() {
        if (this.idArray == null) {
            return "";
        }
        if (this.idJavaType == null) {
            this.idJavaType = this.getColumnJavaType(this.idArray[0]);
        }
        return this.idJavaType;
    }

    public int getIdLength() {
        if (this.idArray == null) {
            return -1;
        }
        return this.getFieldMeta(this.idArray[0]).getLength();
    }

    public PKStrategy getIdStrategy() {
        return this.idStrategy;
    }

    public void setIdStrategy(PKStrategy idStrategy) {
        this.idStrategy = idStrategy;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void addFieldMeta(FieldMeta fieldMeta) {
        this.fieldsMeta.put(fieldMeta.getFieldName().toLowerCase(), fieldMeta);
        String colName = fieldMeta.getColumnName().toLowerCase();
        String fieldName = fieldMeta.getFieldName();
        this.columnFieldMap.put(colName, fieldName);
        if (!fieldName.contains("_")) {
            this.columnFieldMap.put(colName.replace("_", ""), fieldName);
        }
    }

    public String[] getIdArray() {
        return this.idArray;
    }

    public void setIdArray(String[] idArray) {
        this.idArray = idArray;
    }

    public String[] getFieldsArray() {
        return this.fieldsArray;
    }

    public String[] getFieldsNotPartitionKey() {
        ArrayList<String> fields = new ArrayList<String>();
        for (int i = 0; i < this.fieldsArray.length; ++i) {
            FieldMeta fieldMeta = this.fieldsMeta.get(this.fieldsArray[i].toLowerCase());
            if (fieldMeta.isPartitionKey()) continue;
            fields.add(this.fieldsArray[i]);
        }
        String[] result = new String[fields.size()];
        fields.toArray(result);
        return result;
    }

    public void setFieldsArray(String[] fieldsArray) {
        this.fieldsArray = fieldsArray;
        for (int i = 0; i < fieldsArray.length; ++i) {
            this.fieldIndexs.put(fieldsArray[i].toLowerCase(), i);
        }
        if (this.bizIdRelatedColumns != null) {
            this.bizIdRelatedColIndex = new Integer[this.bizIdRelatedColumns.length];
            for (int i = 0; i < this.bizIdRelatedColumns.length; ++i) {
                String colName = this.bizIdRelatedColumns[i].toLowerCase();
                this.bizIdRelatedColIndex[i] = this.fieldIndexs.containsKey(colName) ? this.fieldIndexs.get(colName) : this.fieldIndexs.get(colName.replace("_", ""));
            }
        }
    }

    public void setBizIdRelatedColumns(String[] bizIdRelatedColumns) {
        this.bizIdRelatedColumns = bizIdRelatedColumns;
    }

    public String[] getBizIdRelatedColumns() {
        return this.bizIdRelatedColumns;
    }

    public int getFieldIndex(String fieldName) {
        return this.fieldIndexs.get(fieldName.toLowerCase());
    }

    public String getBizIdSignature() {
        return this.bizIdSignature;
    }

    public Integer[] getBizIdRelatedColIndex() {
        return this.bizIdRelatedColIndex;
    }

    public Integer getIdIndex() {
        return this.rejectIdFieldArray == null ? 0 : this.rejectIdFieldArray.length;
    }

    public String[] getRejectIdFieldArray() {
        return this.rejectIdFieldArray;
    }

    public void setRejectIdFieldArray(String[] rejectIdFieldArray) {
        this.rejectIdFieldArray = rejectIdFieldArray;
    }

    public String getSequence() {
        return this.sequence == null ? "" : this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getColumnName(String fieldName) {
        FieldMeta fieldMeta = this.fieldsMeta.get(fieldName.toLowerCase());
        if (fieldMeta == null) {
            return null;
        }
        return fieldMeta.getColumnName();
    }

    public String getColumnOptName(String fieldName) {
        FieldMeta fieldMeta = this.fieldsMeta.get(fieldName.toLowerCase());
        if (fieldMeta == null) {
            return null;
        }
        return fieldMeta.getColumnOptName();
    }

    public int getColumnJdbcType(String fieldName) {
        FieldMeta fieldMeta = this.fieldsMeta.get(fieldName.toLowerCase());
        if (fieldMeta == null) {
            return -1;
        }
        return fieldMeta.getType();
    }

    public String getColumnJavaType(String fieldName) {
        FieldMeta fieldMeta = this.fieldsMeta.get(fieldName.toLowerCase());
        if (fieldMeta == null) {
            return null;
        }
        return fieldMeta.getFieldType();
    }

    public String getSchemaTable(String shardingTable, Integer dbType) {
        String table = this.tableName;
        if (StringUtil.isNotBlank(shardingTable)) {
            table = shardingTable;
        }
        table = ReservedWordsUtil.convertWord(table, dbType);
        if (this.schema == null) {
            return table;
        }
        if (table.startsWith(this.schema.concat("."))) {
            return table;
        }
        return this.schema.concat(".").concat(table);
    }

    public List<TableCascadeModel> getCascadeModels() {
        return this.cascadeModels;
    }

    public boolean addCascade(TableCascadeModel cascadeModel) {
        Iterator<TableCascadeModel> iter = this.cascadeModels.iterator();
        boolean isRepeat = false;
        while (iter.hasNext()) {
            TableCascadeModel iterModel = iter.next();
            if (!iterModel.getProperty().equals(cascadeModel.getProperty())) continue;
            iter.remove();
            isRepeat = true;
            break;
        }
        this.cascadeModels.add(cascadeModel);
        return isRepeat;
    }

    public String getLoadSql(String shardingTable) {
        if (shardingTable == null || shardingTable.equals(this.tableName)) {
            return this.loadSql;
        }
        return "select ".concat(this.allColumnNames).concat(" from ").concat(this.getSchemaTable(shardingTable, null)).concat(" ").concat(this.idNameWhereSql);
    }

    public void setLoadSql(String loadSql) {
        this.loadSql = loadSql;
    }

    public FieldMeta getFieldMeta(String field) {
        return this.fieldsMeta.get(field.toLowerCase());
    }

    public Integer[] getFieldsTypeArray() {
        return this.fieldsTypeArray;
    }

    public void setFieldsTypeArray(Integer[] fieldsTypeArray) {
        this.fieldsTypeArray = fieldsTypeArray;
    }

    public String[] getFieldsDefaultValue() {
        return this.fieldsDefaultValue;
    }

    public void setFieldsDefaultValue(String[] fieldsDefaultValue) {
        this.fieldsDefaultValue = fieldsDefaultValue;
    }

    public void setFieldsMeta(HashMap<String, FieldMeta> fieldsMeta) {
        this.fieldsMeta = fieldsMeta;
    }

    public Class[] getCascadeTypes() {
        return this.cascadeTypes;
    }

    public void setCascadeTypes(Class[] cascadeTypes) {
        this.cascadeTypes = cascadeTypes;
    }

    public Boolean[] getFieldsNullable() {
        return this.fieldsNullable;
    }

    public void setFieldsNullable(Boolean[] fieldsNullable) {
        this.fieldsNullable = fieldsNullable;
    }

    public String getPkConstraint() {
        return this.pkConstraint;
    }

    public void setPkConstraint(String pkConstraint) {
        this.pkConstraint = pkConstraint;
    }

    public ShardingConfig getShardingConfig() {
        return this.shardingConfig;
    }

    public void setShardingConfig(ShardingConfig shardingConfig) {
        this.shardingConfig = shardingConfig;
    }

    public String getIdNameWhereSql() {
        return this.idNameWhereSql;
    }

    public void setIdNameWhereSql(String idNameWhereSql) {
        this.idNameWhereSql = idNameWhereSql;
    }

    public String getIdArgWhereSql() {
        return this.idArgWhereSql;
    }

    public void setIdArgWhereSql(String idArgWhereSql) {
        this.idArgWhereSql = idArgWhereSql;
    }

    public IdGenerator getBusinessIdGenerator() {
        return this.businessIdGenerator;
    }

    public void setBusinessIdGenerator(IdGenerator businessIdGenerator) {
        this.businessIdGenerator = businessIdGenerator;
    }

    public String getBusinessIdField() {
        return this.businessIdField;
    }

    public void setBusinessIdField(String businessIdField) {
        this.businessIdField = businessIdField;
    }

    public Integer getBizIdLength() {
        if (this.bizIdLength == null) {
            return 26;
        }
        return this.bizIdLength;
    }

    public void setBizIdLength(Integer bizIdLength) {
        this.bizIdLength = bizIdLength;
    }

    public Integer getBizIdSequenceSize() {
        return this.bizIdSequenceSize;
    }

    public void setBizIdSequenceSize(Integer bizIdSequenceSize) {
        this.bizIdSequenceSize = bizIdSequenceSize;
    }

    public void setBizIdSignature(String bizIdSignature) {
        this.bizIdSignature = bizIdSignature;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
    }

    public boolean isHasBizIdConfig() {
        return this.hasBizIdConfig;
    }

    public void setHasBizIdConfig(boolean hasBizIdConfig) {
        this.hasBizIdConfig = hasBizIdConfig;
    }

    public boolean isBizIdEqPK() {
        return this.bizIdEqPK;
    }

    public void setBizIdEqPK(boolean bizIdEqPK) {
        this.bizIdEqPK = bizIdEqPK;
    }

    public String getAllColumnNames() {
        return this.allColumnNames;
    }

    public void setAllColumnNames(String allColumnNames) {
        this.allColumnNames = allColumnNames;
    }

    public HashMap<String, String> getColumnFieldMap() {
        return this.columnFieldMap;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public List<FieldSecureConfig> getSecureFields() {
        return this.secureFields;
    }

    public void addSecureField(FieldSecureConfig fieldSecureConfig) {
        if (!fieldSecureConfig.getSecureType().equals((Object)SecureType.ENCRYPT)) {
            this.secureFields.add(0, fieldSecureConfig);
        } else {
            this.secureFields.add(fieldSecureConfig);
        }
    }

    public IgnoreCaseSet getSecureColumns() {
        return this.secureColumns;
    }

    public void setSecureColumns(IgnoreCaseSet secureColumns) {
        this.secureColumns = secureColumns;
    }

    public DataVersionConfig getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(DataVersionConfig dataVersion) {
        this.dataVersion = dataVersion;
    }

    public String getTenantField() {
        return this.tenantField;
    }

    public void setTenantField(String tenantField) {
        this.tenantField = tenantField;
    }

    public IndexModel[] getIndexModels() {
        return this.indexModels;
    }

    public void setIndexModels(IndexModel[] indexModels) {
        this.indexModels = indexModels;
    }

    public Map<String, String[]> getForeignFields() {
        return this.foreignFields;
    }

    public void setForeignFields(Map<String, String[]> foreignFields) {
        this.foreignFields = foreignFields;
    }
}

