/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.utils.FileUtil;
import org.sagacity.sqltoy.utils.IdUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlToyConstants {
    protected static final Logger logger = LoggerFactory.getLogger(SqlToyConstants.class);
    public static HashMap<String, String> filters = new HashMap<String, String>(){
        private static final long serialVersionUID = 1636155921862321269L;
        {
            this.put("(", ")");
            this.put("'", "'");
            this.put("\"", "\"");
            this.put("[", "]");
            this.put("{", "}");
        }
    };
    public static String UN_SUPPORT_MESSAGE = "This feature is currently not supported!";
    public static final String DEFAULT_NULL = "_SQLTOY_NULL_FLAG";
    public static String UN_MATCH_DIALECT_MESSAGE = "Failed to correctly match the corresponding database dialect!";
    public static String UNION_ALL_REGEX = "\\W+union\\s+\\all\\W+";
    public static String UNION_REGEX = "\\W+union\\W+";
    public static String DEFAULT_PARAM_NAME = "sagParamIndexName";
    public static final String RANDOM_NAMED = "sagRandomSize";
    public static final String PAGE_FIRST_PARAM_NAME = "pageFirstParamName";
    public static final String PAGE_LAST_PARAM_NAME = "pageLastParamName";
    public static final String TEMPLATE_TABLE_HOLDER = "@templateTable";
    public static String UNCACHED_KEY_RESULT = "[${value}]\u672a\u5b9a\u4e49";
    private static Map<String, String> sqlToyProps = new HashMap<String, String>();
    private static final String DEFAULT_CONFIG = "org/sagacity/sqltoy/sqltoy-default.properties";
    public static final String XML_FETURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    public static int WORKER_ID = 0;
    public static int DATA_CENTER_ID = 0;
    public static String SERVER_ID;
    public static String keywordSign;
    public static int SQL_IN_MAX;
    public static int PARALLEL_MAXWAIT_SECONDS;
    public static int FETCH_SIZE;
    public static int DEFAULT_PAGE_SIZE;
    public static boolean executeSqlBlankToNull;
    public static String INTERMEDIATE_TABLE;
    public static String INTERMEDIATE_TABLE1;
    public static final Pattern paramPattern;
    public static final Pattern SQL_NAMED_PATTERN;
    public static final Pattern NOSQL_NAMED_PATTERN;
    public static final Pattern withPattern;
    public static final Pattern otherWithPattern;
    public static final Pattern BLANK_END;
    public static final Pattern NOT_PRINT_REGEX;
    public static final Pattern DO_PRINT_REGEX;
    public static final Pattern IGNORE_EMPTY_REGEX;
    public static final Pattern INCLUDE_PATTERN;
    public static final Pattern INCLUDE_PARAM_PATTERN;
    public static final String MARK_ORIGINAL_START = " /*-- sqltoy_original_mark_start --*/ ";
    public static final String MARK_ORIGINAL_END = " /*-- sqltoy_original_mark_end --*/ ";
    public static final String MERGE_ALIAS_ON = ") tv on (";
    public static final String MERGE_ALIAS_ON_REGEX = "\\)\\s+tv\\s+on\\s+\\(";
    public static final String MERGE_UPDATE = " when matched then update set ";
    public static final String MERGE_INSERT = " when not matched then insert ";

    private static LinkedHashMap<String, String> parseParams(String template) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        Matcher m = paramPattern.matcher(template);
        while (m.find()) {
            String group = m.group();
            paramsMap.put(group, group.substring(2, group.length() - 1).trim());
        }
        return paramsMap;
    }

    public static String getKeyValue(String key) {
        String result = sqlToyProps.get(key);
        if (result == null) {
            result = System.getProperty(key);
        }
        return result;
    }

    public static String getKeyValue(String key, String defaultValue) {
        String result = sqlToyProps.get(key);
        if (result == null) {
            result = System.getProperty(key);
        }
        if (StringUtil.isNotBlank(result)) {
            return result;
        }
        return defaultValue;
    }

    public static boolean db2WithUR() {
        return Boolean.parseBoolean(SqlToyConstants.getKeyValue("sqltoy.db2.search.with.ur", "true"));
    }

    public static int getWarnThresholds() {
        return Integer.parseInt(SqlToyConstants.getKeyValue("sqltoy.fetch.result.warn.thresholds", "25000"));
    }

    public static int getMaxCodeSqlCount() {
        return Integer.parseInt(SqlToyConstants.getKeyValue("sqltoy.max.code.sql.count", "2500"));
    }

    public static Long getMaxThresholds() {
        return Long.parseLong(SqlToyConstants.getKeyValue("sqltoy.fetch.result.max.thresholds", "999999999999"));
    }

    public static boolean oraclePageIgnoreOrder() {
        return Boolean.parseBoolean(SqlToyConstants.getKeyValue("sqltoy.oracle.page.ignore.order", "false"));
    }

    public static boolean showDatasourceInfo() {
        return Boolean.parseBoolean(SqlToyConstants.getKeyValue("sqltoy.show.datasource.info", "false"));
    }

    private static void loadPropertyFile(String propertiesFile) {
        if (StringUtil.isBlank(propertiesFile)) {
            return;
        }
        InputStream fis = null;
        try {
            Properties props = new Properties();
            fis = FileUtil.getFileInputStream(propertiesFile);
            if (fis != null) {
                props.load(fis);
                sqlToyProps.putAll(props);
                fis.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void loadProperties(Map<String, String> keyValues) {
        SqlToyConstants.loadPropertyFile(DEFAULT_CONFIG);
        if (keyValues != null && !keyValues.isEmpty()) {
            sqlToyProps.putAll(keyValues);
        }
    }

    public static String getDefaultValue(Integer dbType, String defaultValue) {
        String realDefault = SqlToyConstants.getKeyValue(defaultValue);
        if (realDefault == null) {
            if ("CURRENT TIMESTAMP".equals(defaultValue.toUpperCase())) {
                return "CURRENT_TIMESTAMP";
            }
            return defaultValue;
        }
        return realDefault;
    }

    public static void setUncachedKeyResult(String uncachedKeyResult) {
        UNCACHED_KEY_RESULT = uncachedKeyResult;
    }

    public static String replaceParams(String template) {
        if (StringUtil.isBlank(template)) {
            return template;
        }
        LinkedHashMap<String, String> paramsMap = SqlToyConstants.parseParams(template);
        String result = template;
        if (paramsMap.size() > 0) {
            for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
                String value = SqlToyConstants.getKeyValue(entry.getValue());
                if (value == null) continue;
                result = result.replace(entry.getKey(), value);
            }
        }
        return result;
    }

    public static int getLoadAllBatchSize() {
        return Integer.parseInt(SqlToyConstants.getKeyValue("sqltoy.loadAll.batchsize", "1000"));
    }

    public static boolean openSqlSign() {
        return Boolean.parseBoolean(SqlToyConstants.getKeyValue("sqltoy.open.sqlsign", "true"));
    }

    public static void setWorkerAndDataCenterId(Integer workerId, Integer dataCenterId, Integer serverId) {
        try {
            String serverNode;
            String keyValue;
            String serverIdentity = IdUtil.getLastIp(2);
            int id = Integer.parseInt(serverIdentity == null ? "0" : serverIdentity);
            if (workerId == null && (keyValue = SqlToyConstants.getKeyValue("sqltoy.snowflake.workerId")) != null) {
                workerId = Integer.parseInt(keyValue);
            }
            if (dataCenterId == null && (keyValue = SqlToyConstants.getKeyValue("sqltoy.snowflake.dataCenterId")) != null) {
                dataCenterId = Integer.parseInt(keyValue);
            }
            WORKER_ID = workerId != null && workerId > 0 && workerId < 32 ? workerId : (id > 31 ? id % 10 : id);
            DATA_CENTER_ID = dataCenterId != null && dataCenterId > 0 && dataCenterId < 32 ? dataCenterId : (id > 31 ? id / 10 : id);
            String string = serverNode = serverId == null ? SqlToyConstants.getKeyValue("sqltoy.server.id") : "" + serverId;
            if (serverNode != null) {
                if ((serverNode = StringUtil.addLeftZero2Len(serverNode, 3)).length() > 3) {
                    serverNode = serverNode.substring(serverNode.length() - 3);
                }
                SERVER_ID = serverNode;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8bbe\u7f6eworkerId\u548cdataCenterId\u53d1\u751f\u9519\u8bef:{}", (Object)e.getMessage());
        }
    }

    static {
        keywordSign = "'";
        SQL_IN_MAX = 999;
        PARALLEL_MAXWAIT_SECONDS = 1800;
        FETCH_SIZE = -1;
        DEFAULT_PAGE_SIZE = 10;
        executeSqlBlankToNull = true;
        INTERMEDIATE_TABLE = "SAG_INTERMEDIATE_TABLE";
        INTERMEDIATE_TABLE1 = "SAG_INTERMEDIATE_TABLE1";
        paramPattern = Pattern.compile("\\$\\{\\s*[0-9a-zA-Z\u4e00-\u9fa5]+((\\.|\\_)[0-9a-zA-Z\u4e00-\u9fa5]+)*(\\[\\d*(\\,)?\\d*\\])?\\s*\\}");
        SQL_NAMED_PATTERN = Pattern.compile("[^A-Za-z0-9_:\u4e00-\u9fa5]\\:\\s*[a-zA-Z\u4e00-\u9fa5][a-zA-Z0-9_\u4e00-\u9fa5]*(\\.[\\w\u4e00-\u9fa5]+)*(\\[\\d+\\](\\.[a-zA-Z0-9_\u4e00-\u9fa5]+)*)?\\s?");
        NOSQL_NAMED_PATTERN = Pattern.compile("(?i)\\@(param|blank|value)?\\(\\s*\\:\\s*[a-zA-Z\u4e00-\u9fa5][a-zA-Z0-9_\u4e00-\u9fa5]*(\\.[\\w\u4e00-\u9fa5]+)*(\\[\\d+\\](\\.[a-zA-Z0-9_\u4e00-\u9fa5]+)*)?\\s*\\)");
        withPattern = Pattern.compile("(?i)\\s*with\\s+([a-z]+\\s+)?[a-z|0-9|\\_]+\\s*(\\([a-z|0-9|\\_|\\s|\\,]+\\))?\\s+as\\s*(\\s+[a-z|\\_]+){0,2}\\s*\\(");
        otherWithPattern = Pattern.compile("(?i)\\s*\\,\\s*([a-z]+\\s+)?[a-z|0-9|\\_]+\\s*(\\([a-z|0-9|\\_|\\s|\\,]+\\))?\\s+as\\s*(\\s+[a-z|\\_]+){0,2}\\s*\\(");
        BLANK_END = Pattern.compile("\\s$");
        NOT_PRINT_REGEX = Pattern.compile("(?i)\\#not\\_(print|debug)\\#");
        DO_PRINT_REGEX = Pattern.compile("(?i)\\#(print|debug)\\#");
        IGNORE_EMPTY_REGEX = Pattern.compile("(?i)\\#ignore_all_null_set\\#");
        INCLUDE_PATTERN = Pattern.compile("(?i)\\@include\\([\\w\\W]*\\)");
        INCLUDE_PARAM_PATTERN = Pattern.compile("(?i)\\@include\\(\\s*\\:\\s*[a-zA-Z\u4e00-\u9fa5][a-zA-Z0-9_\u4e00-\u9fa5]*[\\w\\W]*\\)");
    }
}

